/***********************************************************************/
/*    DO Function Block 1                                              */
/***********************************************************************/

BLOCK func5_DO_1_block
{
    TYPE    FUNCTION;
    NUMBER    13;
}

func5_DO_1_blk_reserve                      LIKE VARIABLE    phys_blk_reserve
{
}

VARIABLE func5_DO_1_blk_object
{
    LABEL       [blk_block_object];
    HELP        [blk_block_object_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    2,    [blk_block_object_FUNCTION]        }
    }
    HANDLING    READ;
}

VARIABLE func5_DO_1_blk_parent_class
{
    LABEL       [blk_parent_class];
    HELP        [func_blk_parent_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    2,    [func_blk_parent_class_OUTPUT]    }
    }
    HANDLING    READ;
}

VARIABLE func5_DO_1_blk_class
{
    LABEL       [blk_class];
    HELP        [func_blk_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    2,      [func_blk_class_DO]      },
        {    250,    [not_used]               },
        {    251,    [none]                   },
        {    252,    [unknown]                },
        {    253,    [special]                }
    }
    HANDLING    READ;
}

func5_DO_1_blk_dd_reference               LIKE VARIABLE    phys_blk_dd_reference
{
}

func5_DO_1_blk_dd_rev                     LIKE VARIABLE    phys_blk_dd_rev
{
}

func5_DO_1_blk_profile                    LIKE VARIABLE    phys_blk_profile
{
}

func5_DO_1_blk_profile_rev                LIKE VARIABLE    phys_blk_profile_rev
{
}

func5_DO_1_blk_execution_time             LIKE VARIABLE    phys_blk_execution_time
{
}

func5_DO_1_blk_num_parameters             LIKE VARIABLE    phys_blk_num_parameters
{
}

func5_DO_1_blk_index_view_1               LIKE VARIABLE    phys_blk_index_view_1
{
}

func5_DO_1_blk_num_view_lists             LIKE VARIABLE    phys_blk_num_view_lists
{
}

func5_DO_1_st_rev                         LIKE VARIABLE    phys_st_rev
{
}

func5_DO_1_tag_desc                       LIKE VARIABLE    phys_tag_desc
{
    REDEFINE LABEL        [MC_DO_1_tag_desc];
    TYPE                  ASCII (32)
    {
        REDEFINE DEFAULT_VALUE  "";
    }
}

func5_DO_1_strategy                       LIKE VARIABLE    phys_strategy
{
}

func5_DO_1_alert_key                      LIKE VARIABLE    phys_alert_key
{
}

VARIABLE func5_DO_1_target_mode
{
    LABEL       [target_mode];
    HELP        [target_mode_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x02,    [mode_RCAS]              },
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x20,    [mode_LO]                },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_1_actual_mode
{
    LABEL       [actual_mode];
    HELP        [actual_mode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x02,    [mode_RCAS]              },
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x20,    [mode_LO]                },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE func5_DO_1_permitted_mode
{
    LABEL       [permitted_mode];
    HELP        [permitted_mode_help];
    CLASS       CONTAINED;
    TYPE        BIT_ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x02,    [mode_RCAS]              },
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x20,    [mode_LO]                },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE func5_DO_1_normal_mode
{
    LABEL       [normal_mode];
    HELP        [normal_mode_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x02,    [mode_RCAS]              },
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x20,    [mode_LO]                },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

func5_DO_1_current_state_alarm_sum        LIKE VARIABLE    phys_current_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func5_DO_1_unacknowledged_state_alarm_sum LIKE VARIABLE    phys_unacknowledged_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func5_DO_1_unreported_state_alarm_sum     LIKE VARIABLE    phys_unreported_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func5_DO_1_disabled_state_alarm_sum       LIKE VARIABLE    phys_disabled_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

VARIABLE func5_DO_1_batch_id
{
    LABEL       [func_batch_id];
    HELP        [func_batch_id_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (4)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_1_batch_unit
{
    LABEL       [func_batch_unit];
    HELP        [func_batch_unit_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_1_batch_operation
{
    LABEL       [func_batch_operation];
    HELP        [func_batch_operation_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_1_batch_phase
{
    LABEL       [func_batch_phase];
    HELP        [func_batch_phase_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

/*---------------------------------------------------------------------*/
/*    DO-1 : Additional Parameter                                      */
/*---------------------------------------------------------------------*/

VARIABLE func5_DO_1_setpoint_value
{
    LABEL       [func_ao_setpoint_value];
    HELP        [func_ao_setpoint_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_1_setpoint_status_quality
{
    LABEL       [status_quality];
    HELP        [func_ao_setpoint_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_INPUT_NO_RCAS
    }
    POST_EDIT_ACTIONS
    {
        method_set_status_limit_func5_DO_1
    }
    HANDLING    READ & WRITE;
}

func5_DO_1_setpoint_status_limit          LIKE VARIABLE    func5_DO_1_setpoint_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_INPUT_LIMIT (func5_DO_1_setpoint_status_quality)
    }
}

VARIABLE func5_DO_1_out_value
{
    LABEL       [func_out_value];
    HELP        [func_ao_out_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }

    HANDLING
        IF ((func5_DO_1_target_mode == BLOCK_MODE_MAN) || (func5_DO_1_target_mode == BLOCK_MODE_LO))
        {
            READ & WRITE;
        }
        ELSE {
            READ;
        }
}

VARIABLE func5_DO_1_out_status_quality
{
    LABEL       [status_quality];
    HELP        [func_out_status_help];
    CLASS        OUTPUT & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        IF ((func5_DO_1_target_mode == BLOCK_MODE_MAN) || (func5_DO_1_target_mode == BLOCK_MODE_LO))
        {
            STATUS_INPUT_NO_RCAS
        }
        ELSE {
            STATUS_OUTPUT_NO_RCAS
        }
    }
    POST_EDIT_ACTIONS
    {
        IF ((func5_DO_1_target_mode == BLOCK_MODE_MAN) || (func5_DO_1_target_mode == BLOCK_MODE_LO))
        {
            method_set_status_limit_func5_DO_1
        }
    }
    HANDLING
        IF ((func5_DO_1_target_mode == BLOCK_MODE_MAN) || (func5_DO_1_target_mode == BLOCK_MODE_LO))
        {
            READ & WRITE;
        }
        ELSE {
            READ;
        }
}

func5_DO_1_out_status_limit               LIKE VARIABLE    func5_DO_1_out_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func5_DO_1_out_status_quality)
    }
}

VARIABLE func5_DO_1_readback_value
{
    LABEL       [func_do_readback_value];
    HELP        [func_do_readback_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ;
}

VARIABLE func5_DO_1_readback_status_quality
{
    LABEL       [status_quality];
    HELP        [func_do_readback_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_NO_RCAS
    }
    HANDLING    READ;
}

func5_DO_1_readback_status_limit          LIKE VARIABLE    func5_DO_1_readback_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func5_DO_1_rcas_in_value
{
    LABEL       [func_rcas_in_value];
    HELP        [func_rcas_in_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_1_rcas_in_status_quality
{
    LABEL       [status_quality];
    HELP        [func_rcas_in_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_INPUT_RCAS
    }
    POST_EDIT_ACTIONS
    {
        method_set_status_limit_func5_DO_1
    }
    HANDLING    READ & WRITE;
}

func5_DO_1_rcas_in_status_limit           LIKE VARIABLE    func5_DO_1_rcas_in_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func5_DO_1_rcas_in_status_quality)
    }
}

VARIABLE func5_DO_1_in_channel
{
    LABEL       [func_channel];
    HELP        [func_channel_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE   1;
        {1,    "Mod_Out_D_1(TB)"              },
        {2,    "Mod_Out_D_2(TB)"              },
        {3,    "Mod_Out_D_3(TB)"              },
        {4,    "Mod_Out_D_4(TB)"              }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_1_invert
{
    LABEL       [func_invert];
    HELP        [func_invert_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [func_invert_NOT_INVERT]    },
        {    1,    [func_invert_INVERT]        }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_1_fsafe_time
{
    LABEL       [func_ao_fsafe_time];
    HELP        [func_ao_fsafe_time_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE    0.0;
    }
    CONSTANT_UNIT    [sec];
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_1_fsafe_type
{
    LABEL       [func_ao_fsafe_type];
    HELP        [func_ao_fsafe_type_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    2;
        {    0,    [func_ao_fsafe_type_FAIL_SAFE_VALUE]        },
        {    1,    [func_ao_fsafe_type_STORING_LAST_SETPOINT]  },
        {    2,    [func_ao_fsafe_type_FAIL_SAFE_POSITION]     }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_1_fsafe_value
{
    LABEL       [func_do_fsafe_value];
    HELP        [func_do_fsafe_value_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING        READ & WRITE;
}

VARIABLE func5_DO_1_rcas_out_value
{
    LABEL       [func_rcas_out_value];
    HELP        [func_rcas_out_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
}

VARIABLE func5_DO_1_rcas_out_status_quality
{
    LABEL       [status_quality];
    HELP        [func_rcas_out_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_RCAS
    }
    HANDLING    READ;
}

func5_DO_1_rcas_out_status_limit          LIKE VARIABLE    func5_DO_1_rcas_out_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func5_DO_1_simulate_value
{
    LABEL       [func_simulate_value];
    HELP        [func_ao_simulate_value_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_1_simulate_status_quality
{
    LABEL       [status_quality];
    HELP        [func_simulate_status_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_INPUT_NO_RCAS
    }
    POST_EDIT_ACTIONS
    {
        method_set_status_limit_func5_DO_1
    }
    HANDLING    READ & WRITE;
}

func5_DO_1_simulate_status_limit          LIKE VARIABLE    func5_DO_1_simulate_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func5_DO_1_simulate_status_quality)
    }
}

VARIABLE func5_DO_1_simulation_enabled
{
    LABEL       [func_simulation_enabled];
    HELP        [func_simulation_enabled_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        {    0,    [disabled]       },
        {    1,    [enabled]        }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_1_check_back
{
    LABEL       [func_check_back];
    HELP        [func_check_back_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        BIT_ENUMERATED (3)
    {
        {    0,                      [dia_OK],                [dia_OK_help]                },
        {    CB_FAIL_SAFE,           [cb_FAIL_SAFE],          [cb_FAIL_SAFE_help]          },
        {    CB_REQ_LOC_OP,          [cb_REQ_LOC_OP],         [cb_REQ_LOC_OP_help]         },
        {    CB_LOCAL_OP,            [cb_LOCAL_OP],           [cb_LOCAL_OP_help]           },
        {    CB_OVERRIDE,            [cb_OVERRIDE],           [cb_OVERRIDE_help]           },
        {    CB_DISC_DIR,            [cb_DISC_DIR],           [cb_DISC_DIR_help]           },
        {    CB_TORQUE_D_OP,         [cb_TORQUE_D_OP],        [cb_TORQUE_D_OP_help]        },
        {    CB_TORQUE_D_CL,         [cb_TORQUE_D_CL],        [cb_TORQUE_D_CL_help]        },
        {    CB_TRAV_TIME,           [cb_TRAV_TIME],          [cb_TRAV_TIME_help]          },
        {    CB_ACT_OPEN,            [cb_ACT_OPEN],           [cb_ACT_OPEN_help]           },
        {    CB_ACT_CLOSE,           [cb_ACT_CLOSE],          [cb_ACT_CLOSE_help]          },
        {    CB_UPDATE_EVT,          [cb_UPDATE_EVT],         [cb_UPDATE_EVT_help]         },
        {    CB_SIMULATE,            [cb_SIMULATE],           [cb_SIMULATE_help]           },
        {    CB_DISTURBANCE,         [cb_DISTURBANCE],        [cb_DISTURBANCE_help]        },
        {    CB_CONTR_ERR,           [cb_CONTR_ERR],          [cb_CONTR_ERR_help]          },
        {    CB_CONTR_INACT,         [cb_CONTR_INACT],        [cb_CONTR_INACT_help]        },
        {    CB_SELFTEST,            [cb_SELFTEST],           [cb_SELFTEST_help]           },
        {    CB_TOT_VALVE_TRAV,      [cb_TOT_VALVE_TRAV],     [cb_TOT_VALVE_TRAV_help]     },
        {    CB_BREAK_TIME_UNDER,    [cb_BREAK_TIME_UNDER],   [cb_BREAK_TIME_UNDER_help]   },
        {    CB_BREAK_TIME_OVER,     [cb_BREAK_TIME_OVER],    [cb_BREAK_TIME_OVER_help]    },
        {    CB_CYCLE_TEST,          [cb_CYCLE_TEST],         [cb_CYCLE_TEST_help]         },
        {    CB_TRAVEL_TIME_UNDER,   [cb_TRAVEL_TIME_UNDER],  [cb_TRAVEL_TIME_UNDER_help]  },
        {    CB_TRAVEL_TIME_OVER,    [cb_TRAVEL_TIME_OVER],   [cb_TRAVEL_TIME_OVER_help]   }
    }
    HANDLING    READ;
    STYLE      "MULTILINE 10 8" ;
}

VARIABLE func5_DO_1_check_back_mask
{
    LABEL       [func_check_back_mask];
    HELP        [func_check_back_mask_help];
    CLASS       CONTAINED;
    TYPE        BIT_ENUMERATED (3)
    {
        {    CB_FAIL_SAFE,           [cb_FAIL_SAFE],          [cb_FAIL_SAFE_help]          },
        {    CB_REQ_LOC_OP,          [cb_REQ_LOC_OP],         [cb_REQ_LOC_OP_help]         },
        {    CB_LOCAL_OP,            [cb_LOCAL_OP],           [cb_LOCAL_OP_help]           },
        {    CB_OVERRIDE,            [cb_OVERRIDE],           [cb_OVERRIDE_help]           },
        {    CB_DISC_DIR,            [cb_DISC_DIR],           [cb_DISC_DIR_help]           },
        {    CB_TORQUE_D_OP,         [cb_TORQUE_D_OP],        [cb_TORQUE_D_OP_help]        },
        {    CB_TORQUE_D_CL,         [cb_TORQUE_D_CL],        [cb_TORQUE_D_CL_help]        },
        {    CB_TRAV_TIME,           [cb_TRAV_TIME],          [cb_TRAV_TIME_help]          },
        {    CB_ACT_OPEN,            [cb_ACT_OPEN],           [cb_ACT_OPEN_help]           },
        {    CB_ACT_CLOSE,           [cb_ACT_CLOSE],          [cb_ACT_CLOSE_help]          },
        {    CB_UPDATE_EVT,          [cb_UPDATE_EVT],         [cb_UPDATE_EVT_help]         },
        {    CB_SIMULATE,            [cb_SIMULATE],           [cb_SIMULATE_help]           },
        {    CB_DISTURBANCE,         [cb_DISTURBANCE],        [cb_DISTURBANCE_help]        },
        {    CB_CONTR_ERR,           [cb_CONTR_ERR],          [cb_CONTR_ERR_help]          },
        {    CB_CONTR_INACT,         [cb_CONTR_INACT],        [cb_CONTR_INACT_help]        },
        {    CB_SELFTEST,            [cb_SELFTEST],           [cb_SELFTEST_help]           },
        {    CB_TOT_VALVE_TRAV,      [cb_TOT_VALVE_TRAV],     [cb_TOT_VALVE_TRAV_help]     },
        {    CB_BREAK_TIME_UNDER,    [cb_BREAK_TIME_UNDER],   [cb_BREAK_TIME_UNDER_help]   },
        {    CB_BREAK_TIME_OVER,     [cb_BREAK_TIME_OVER],    [cb_BREAK_TIME_OVER_help]    },
        {    CB_CYCLE_TEST,          [cb_CYCLE_TEST],         [cb_CYCLE_TEST_help]         },
        {    CB_TRAVEL_TIME_UNDER,   [cb_TRAVEL_TIME_UNDER],  [cb_TRAVEL_TIME_UNDER_help]  },
        {    CB_TRAVEL_TIME_OVER,    [cb_TRAVEL_TIME_OVER],   [cb_TRAVEL_TIME_OVER_help]   }
    }
    HANDLING    READ;
    STYLE      "MULTILINE 10 8" ;
}

func5_DO_1_out_channel                    LIKE VARIABLE    func5_DO_1_in_channel
{
}

/***********************************************************************/
/*    DO-1 : COMMAND                                                   */
/***********************************************************************/

COMMAND read_func5_DO_1_blk
{
    BLOCK func5_DO_1_block;
    INDEX 0;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_1_blk_reserve,        func5_DO_1_blk_object,
            func5_DO_1_blk_parent_class,   func5_DO_1_blk_class,
            func5_DO_1_blk_dd_reference,   func5_DO_1_blk_dd_rev,
            func5_DO_1_blk_profile,        func5_DO_1_blk_profile_rev,
            func5_DO_1_blk_execution_time, func5_DO_1_blk_num_parameters,
            func5_DO_1_blk_index_view_1,   func5_DO_1_blk_num_view_lists
        }
    }
}

COMMAND read_func5_DO_1_st_rev
{
    BLOCK func5_DO_1_block;
    INDEX 1;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_1_st_rev
        }
    }
}

COMMAND read_func5_DO_1_tag_desc
{
    BLOCK func5_DO_1_block;
    INDEX 2;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_1_tag_desc
        }
    }
}

COMMAND write_func5_DO_1_tag_desc
{
    BLOCK func5_DO_1_block;
    INDEX 2;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_1_tag_desc
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_1_strategy
{
    BLOCK func5_DO_1_block;
    INDEX 3;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_1_strategy
        }
    }
}

COMMAND write_func5_DO_1_strategy
{
    BLOCK func5_DO_1_block;
    INDEX 3;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_1_strategy
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_1_alert_key
{
    BLOCK func5_DO_1_block;
    INDEX 4;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_1_alert_key
        }
    }
}

COMMAND write_func5_DO_1_alert_key
{
    BLOCK func5_DO_1_block;
    INDEX 4;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_1_alert_key
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_1_target_mode
{
    BLOCK func5_DO_1_block;
    INDEX 5;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_1_target_mode
        }
    }
}

COMMAND write_func5_DO_1_target_mode
{
    BLOCK func5_DO_1_block;
    INDEX 5;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_1_target_mode
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_1_mode
{
    BLOCK func5_DO_1_block;
    INDEX 6;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             func5_DO_1_actual_mode, func5_DO_1_permitted_mode, func5_DO_1_normal_mode
        }
    }
}

COMMAND read_func5_DO_1_alarm
{
    BLOCK func5_DO_1_block;
    INDEX 7;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_1_current_state_alarm_sum, func5_DO_1_unacknowledged_state_alarm_sum,
            func5_DO_1_unreported_state_alarm_sum, func5_DO_1_disabled_state_alarm_sum
        }
    }
}

COMMAND read_func5_DO_1_batch_information
{
    BLOCK func5_DO_1_block;
    INDEX 8;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_1_batch_id, func5_DO_1_batch_unit, func5_DO_1_batch_operation, func5_DO_1_batch_phase
        }
    }
}

COMMAND write_func5_DO_1_batch_information
{
    BLOCK func5_DO_1_block;
    INDEX 8;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_1_batch_id, func5_DO_1_batch_unit, func5_DO_1_batch_operation, func5_DO_1_batch_phase
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_1_setpoint
{
    BLOCK func5_DO_1_block;
    INDEX 9;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_1_setpoint_value,
            func5_DO_1_setpoint_status_quality    <0xFC>,
            func5_DO_1_setpoint_status_limit      <0x03>
        }
    }
}

COMMAND write_func5_DO_1_setpoint
{
    BLOCK func5_DO_1_block;
    INDEX 9;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_1_setpoint_value,
            func5_DO_1_setpoint_status_quality    <0xFC>,
            func5_DO_1_setpoint_status_limit      <0x03>
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_1_out
{
    BLOCK func5_DO_1_block;
    INDEX 10;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_1_out_value,
            func5_DO_1_out_status_quality      <0xFC>,
            func5_DO_1_out_status_limit        <0x03>
        }
    }
}

COMMAND write_func5_DO_1_out
{
    BLOCK func5_DO_1_block;
    INDEX 10;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_1_out_value,
            func5_DO_1_out_status_quality      <0xFC>,
            func5_DO_1_out_status_limit        <0x03>
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_1_readback
{
    BLOCK func5_DO_1_block;
    INDEX 12;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_1_readback_value,
            func5_DO_1_readback_status_quality    <0xFC>,
            func5_DO_1_readback_status_limit      <0x03>
        }
    }
}

COMMAND read_func5_DO_1_rcas_in
{
    BLOCK func5_DO_1_block;
    INDEX 14;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_1_rcas_in_value,
            func5_DO_1_rcas_in_status_quality      <0xFC>,
            func5_DO_1_rcas_in_status_limit        <0x03>
        }
    }
}

COMMAND write_func5_DO_1_rcas_in
{
    BLOCK func5_DO_1_block;
    INDEX 14;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_1_rcas_in_value,
            func5_DO_1_rcas_in_status_quality      <0xFC>,
            func5_DO_1_rcas_in_status_limit        <0x03>
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_1_in_channel
{
    BLOCK func5_DO_1_block;
    INDEX 17;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_1_in_channel
        }
    }
}

COMMAND write_func5_DO_1_in_channel
{
    BLOCK func5_DO_1_block;
    INDEX 17;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_1_in_channel
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_1_invert
{
    BLOCK func5_DO_1_block;
    INDEX 18;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_1_invert
        }
    }
}

COMMAND write_func5_DO_1_invert
{
    BLOCK func5_DO_1_block;
    INDEX 18;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_1_invert
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_1_fsafe_time
{
    BLOCK func5_DO_1_block;
    INDEX 19;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_1_fsafe_time
        }
    }
}

COMMAND write_func5_DO_1_fsafe_time
{
    BLOCK func5_DO_1_block;
    INDEX 19;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_1_fsafe_time
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_1_fsafe_type
{
    BLOCK func5_DO_1_block;
    INDEX 20;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_1_fsafe_type
        }
    }
}

COMMAND write_func5_DO_1_fsafe_type
{
    BLOCK func5_DO_1_block;
    INDEX 20;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_1_fsafe_type
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_1_fsafe_value
{
    BLOCK func5_DO_1_block;
    INDEX 21;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_1_fsafe_value
        }
    }
}

COMMAND write_func5_DO_1_fsafe_value
{
    BLOCK func5_DO_1_block;
    INDEX 21;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_1_fsafe_value
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_1_rcas_out_value
{
    BLOCK func5_DO_1_block;
    INDEX 22;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_1_rcas_out_value,
            func5_DO_1_rcas_out_status_quality    <0xFC>,
            func5_DO_1_rcas_out_status_limit      <0x03>

        }
    }
}

COMMAND read_func5_DO_1_simulate
{
    BLOCK func5_DO_1_block;
    INDEX 24;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_1_simulate_status_quality    <0xFC>,
            func5_DO_1_simulate_status_limit      <0x03>,
            func5_DO_1_simulate_value,
            func5_DO_1_simulation_enabled
        }
    }
}

COMMAND write_func5_DO_1_simulate
{
    BLOCK func5_DO_1_block;
    INDEX 24;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_1_simulate_status_quality    <0xFC>,
            func5_DO_1_simulate_status_limit      <0x03>,
            func5_DO_1_simulate_value,
            func5_DO_1_simulation_enabled
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_1_check_back
{
    BLOCK func5_DO_1_block;
    INDEX 33;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_1_check_back
        }
    }
}

COMMAND read_func5_DO_1_check_back_mask
{
    BLOCK func5_DO_1_block;
    INDEX 34;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_1_check_back_mask
        }
    }
}

COMMAND read_func5_DO_1_out_channel
{
    BLOCK func5_DO_1_block;
    INDEX 35;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_1_out_channel
        }
    }
}

COMMAND write_func5_DO_1_out_channel
{
    BLOCK func5_DO_1_block;
    INDEX 35;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_1_out_channel
        }
        REPLY
        {
        }
    }
}

/***********************************************************************/
/*    DO-1 : MENUs                                                     */
/***********************************************************************/

MENU Tab_s_func5_DO_1
{
    LABEL        "DO-1";
    ITEMS
    {
        func5_DO_1_st_rev,
        //func5_DO_1_in_channel,
        func5_DO_1_out_channel,
        func5_DO_1_invert,
        Tab_s_func5_DO_1_batch,
        Tab_s_func5_DO_1_fsafe
    }
}

MENU Tab_m_func5_DO_1
{
    LABEL       "DO-1";
    ITEMS
    {
        func5_DO_1_st_rev,
        //func5_DO_1_in_channel (READ_ONLY),
        func5_DO_1_out_channel (READ_ONLY),
        func5_DO_1_invert      (READ_ONLY),
        Tab_s_func5_DO_1_batch,
        Tab_m_func5_DO_1_fsafe
    }
}

MENU Tab_s_func5_DO_1_batch
{
    LABEL       [menu_ident_batch_info];
    ITEMS
    {
        func5_DO_1_batch_id,
        func5_DO_1_batch_unit,
        func5_DO_1_batch_operation,
        func5_DO_1_batch_phase
    }
}

MENU Tab_s_func5_DO_1_fsafe
{
    LABEL       [menu_fail_safe] ;
    ITEMS
    {
        func5_DO_1_fsafe_type,
        func5_DO_1_fsafe_time,
        func5_DO_1_fsafe_value
    }
}

MENU Tab_m_func5_DO_1_fsafe
{
    LABEL       [menu_fail_safe] ;
    ITEMS
    {
        func5_DO_1_fsafe_type  (READ_ONLY),
        func5_DO_1_fsafe_time  (READ_ONLY),
        func5_DO_1_fsafe_value (READ_ONLY)
    }
}

/*---------------------------------------------------------------------*/
/*    DO-1 : Online-Windows                                            */
/*---------------------------------------------------------------------*/

MENU Page_display_measure_func5_DO_1
{
    LABEL        "DO-1";
    ITEMS
    {
        Group_display_readback_func5_DO_1,
        Group_display_setpoint_func5_DO_1,
        func5_DO_1_check_back,
        Group_display_out_func5_DO_1,
    }
}

MENU Group_display_out_func5_DO_1
{
    LABEL       [func_out_value];
    ITEMS
    {
        func5_DO_1_out_value                (READ_ONLY),
        COLUMNBREAK,
        func5_DO_1_out_status_quality       (READ_ONLY),
        func5_DO_1_out_status_limit         (READ_ONLY)
    }
}

MENU Group_display_readback_func5_DO_1
{
    LABEL       [func_ao_readback_value];
    ITEMS
    {
        func5_DO_1_readback_value,
        COLUMNBREAK,
        func5_DO_1_readback_status_quality,
        func5_DO_1_readback_status_limit
    }
}

MENU Group_display_setpoint_func5_DO_1
{
    LABEL       [func_ao_setpoint_value];
    ITEMS
    {
        func5_DO_1_setpoint_value             (READ_ONLY),
        COLUMNBREAK,
        func5_DO_1_setpoint_status_quality    (READ_ONLY),
        func5_DO_1_setpoint_status_limit      (READ_ONLY)
    }
}

MENU OnlineWindow_S_alarm_func5_DO_1
{
    LABEL        "DO-1";
    ITEMS
    {
        Page_alarm_sum_func5_DO_1,
    }
}

MENU Page_alarm_sum_func5_DO_1
{
    LABEL       [menu_dialog_alarm_sum];
    ITEMS
    {
        func5_DO_1_current_state_alarm_sum,
        func5_DO_1_unreported_state_alarm_sum
    }
}

/*---------------------------------------------------------------------*/
/*    DO-1 : Online-Dialogs                                            */
/*---------------------------------------------------------------------*/

MENU OnlineDialog_operation_func5_DO_1
{
    LABEL        "DO-1";
    ITEMS
    {
        Page_operation_AUTO_func5_DO_1,
        Page_operation_RCAS_func5_DO_1,
        Page_operation_MAN_func5_DO_1,
        Page_simulation_func5_DO_1
    }
}

MENU Page_operation_AUTO_func5_DO_1
{
    LABEL       [mode_AUTO];
    ITEMS
    {
        func5_DO_1_target_mode,
        func5_DO_1_actual_mode,
        Group_setpoint_DO_func5_DO_1,
        Group_readback_func5_DO_1,
        func5_DO_1_check_back,
        method_set
    }
}

MENU Page_operation_RCAS_func5_DO_1
{
    LABEL       [mode_RCAS];
    ITEMS
    {
        func5_DO_1_target_mode,
        func5_DO_1_actual_mode,
        Group_rcas_in_DO_func5_DO_1,
        Group_rcas_out_DO_func5_DO_1,
        Group_readback_func5_DO_1,
        func5_DO_1_check_back,
        method_set
    }
}

MENU Page_operation_MAN_func5_DO_1
{
    LABEL       [mode_MAN];
    ITEMS
    {
        func5_DO_1_target_mode,
        func5_DO_1_actual_mode,
        Group_out_func5_DO_1,
        Group_readback_func5_DO_1,
        func5_DO_1_check_back,
        method_set
    }
}

MENU Page_simulation_func5_DO_1
{
    LABEL       [menu_dialog_simulation];
    ITEMS
    {
        func5_DO_1_simulation_enabled,
        Group_simulation_func5_DO_1,
        func5_DO_1_check_back,
        method_set
    }
}

MENU Group_setpoint_DO_func5_DO_1
{
    LABEL       [func_ao_setpoint_value];
    ITEMS
    {
        func5_DO_1_setpoint_value,
        COLUMNBREAK,
        func5_DO_1_setpoint_status_quality,
        func5_DO_1_setpoint_status_limit
    }
}

MENU Group_readback_func5_DO_1
{
    LABEL       [func_ao_readback_value];
    ITEMS
    {
        func5_DO_1_readback_value,
        COLUMNBREAK,
        func5_DO_1_readback_status_quality,
        func5_DO_1_readback_status_limit
    }
}

MENU Group_rcas_in_DO_func5_DO_1
{
    LABEL       [func_rcas_in_value];
    ITEMS
    {
        func5_DO_1_rcas_in_value,
        COLUMNBREAK,
        func5_DO_1_rcas_in_status_quality,
        func5_DO_1_rcas_in_status_limit
    }
}

MENU Group_rcas_out_DO_func5_DO_1
{
    LABEL       [func_rcas_out_value];
    ITEMS
    {
        func5_DO_1_rcas_out_value,
        COLUMNBREAK,
        func5_DO_1_rcas_out_status_quality,
        func5_DO_1_rcas_out_status_limit
    }
}

MENU Group_out_func5_DO_1
{
    LABEL       [menu_output];
    ITEMS
    {
        func5_DO_1_out_value,
        COLUMNBREAK,
        func5_DO_1_out_status_quality,
        func5_DO_1_out_status_limit
    }
}

MENU Group_simulation_func5_DO_1
{
    LABEL       [menu_dialog_simulation];
    ITEMS
    {
        func5_DO_1_simulate_value,
        COLUMNBREAK,
        func5_DO_1_simulate_status_quality,
        func5_DO_1_simulate_status_limit
    }
}

MENU Page_diagnosis_func5_DO_1
{
    LABEL        "DO-1";
    ITEMS
    {
        func5_DO_1_blk_object,
        func5_DO_1_blk_parent_class,
        func5_DO_1_blk_class,
        func5_DO_1_blk_dd_reference,
        func5_DO_1_blk_dd_rev,
        func5_DO_1_blk_profile,
        func5_DO_1_blk_profile_rev,
        func5_DO_1_st_rev,
        func5_DO_1_actual_mode,
        func5_DO_1_simulation_enabled (READ_ONLY)
    }
}

MENU OnlineDialog_DO_1_setting
{
    LABEL        "DO-1 Block Mode";
    ITEMS
    {
        Page_mode_DO_1
        Page_actuator_DO_1,
    }
}

MENU Page_mode_DO_1
{
    LABEL        "Config Block Mode";
    ITEMS
    {
        Group_mode_DO_1,
        Group_output_DO_1,
        Group_setpoint_DO_1,
        Group_rcas_in_DO_1,
        Group_rcas_out_DO_1,
        method_set
    }
}


MENU Group_mode_DO_1
{
    LABEL        "Config Block Mode";
    ITEMS
    {
        func5_DO_1_target_mode,
        COLUMNBREAK,
        func5_DO_1_actual_mode
    }
}

MENU Group_output_DO_1
{
    LABEL        "Set Output (MAN)"; /* [func_out_value]; */
    ITEMS
    {
        func5_DO_1_out_value,
        COLUMNBREAK,
        func5_DO_1_out_status_quality,
        func5_DO_1_out_status_limit
    }
}

MENU Group_setpoint_DO_1
{
    LABEL        "Set Setpoint from Operator - SP (AUTO)"; /* [func_out_value]; */
    ITEMS
    {
        func5_DO_1_setpoint_value,
        COLUMNBREAK,
        func5_DO_1_setpoint_status_quality,
        func5_DO_1_setpoint_status_limit
    }
}

MENU Group_rcas_in_DO_1
{
    LABEL        "Set Setpoint from Remote Station - RCAS_IN (RCAS)"; /* [func_out_value]; */
    ITEMS
    {
        func5_DO_1_rcas_in_value,
        COLUMNBREAK,
        func5_DO_1_rcas_in_status_quality,
        func5_DO_1_rcas_in_status_limit
    }
}

MENU Group_rcas_out_DO_1
{
    LABEL        "From RCAS_OUT to Remote Station"; /* [func_out_value]; */
    ITEMS
    {
        func5_DO_1_rcas_out_value,
        COLUMNBREAK,
        func5_DO_1_rcas_out_status_quality,
        func5_DO_1_rcas_out_status_limit
    }
}

MENU Page_actuator_DO_1
{
    LABEL        "Feedback";
    ITEMS
    {
        Group_readback_DO_1,
        func5_DO_1_check_back,
        func5_DO_1_current_state_alarm_sum
    }
}

MENU Group_readback_DO_1
{
    LABEL        "Readback to Transducer"; /* [func_out_value]; */
    ITEMS
    {
        func5_DO_1_readback_value,
        COLUMNBREAK,
        func5_DO_1_readback_status_quality,
        func5_DO_1_readback_status_limit
    }
}

MENU OnlineDialog_simulation_DO_1
{
    LABEL        "Simulate DO-1"; /* "Simulate AI"; */
    ITEMS
    {
        Page_simulation_DO_1,
        Page_simulation_out_DO_1
    }
}

MENU Page_simulation_DO_1
{
    LABEL        [menu_dialog_simulation_input];
    ITEMS
    {
        func5_DO_1_simulation_enabled,
        Group_simulate_value_DO_1,
        Group_readback_DO_1,
        method_set
    }
}

MENU Group_simulate_value_DO_1
{
    LABEL     "Simulation Value";
    ITEMS
    {
        func5_DO_1_simulate_value,
        COLUMNBREAK,
        func5_DO_1_simulate_status_quality,
        func5_DO_1_simulate_status_limit
    }
}

MENU Page_simulation_out_DO_1
{
    LABEL       [menu_dialog_simulation_output];
    ITEMS
    {
        Group_mode_DO_1,
        Group_output_DO_1,
        method_set
    }
}

/*---------------------------------------------------------------------*/
/*    DO-1 : Offline-Windows                                           */
/*---------------------------------------------------------------------*/

MENU OfflineWindow_DO_1_geral
{
    LABEL "DO-1"; 
    ITEMS
    {
        Page_basic_DO_1,
        Page_advanced_DO_1
    }
}

MENU Page_basic_DO_1
{
    LABEL [MC_Tab_basic];
    ITEMS
    {
        Group_target_mode_DO_1,
        Group_channel_DO_1,
        Group_Set_Invert_DO_1
    }
}

MENU Page_advanced_DO_1
{
    LABEL [MC_Tab_advanced];
    ITEMS
    {
        Group_fault_set_DO_1,
        Group_batch_DO_1
    }
}

MENU Page_batch_DO_1
{
    LABEL [MC_Batch_Info];
    ITEMS
    {
        Group_batch_DO_1
    }
}

MENU Group_target_mode_DO_1
{
    LABEL "Config Block Mode";
    ITEMS
    {
        func5_DO_1_target_mode,
        COLUMNBREAK,
        method_write_target_mode_DO_1
    }
}

MENU Group_channel_DO_1
{
    LABEL        "Select Channel";
    ITEMS
    {
        //func5_DO_1_in_channel,
        func5_DO_1_out_channel,
        COLUMNBREAK,
        method_write_channel_in_out_DO_1
    }
}

MENU Group_channel_out_DO_1
{
    LABEL        "Select Output";
    ITEMS
    {
        func5_DO_1_out_channel,
        COLUMNBREAK,
        method_write_channel_out_DO_1
    }
}

MENU Group_Set_Invert_DO_1
{
    LABEL "Set Invert Input Value";
    ITEMS
    {
        func5_DO_1_invert,
        COLUMNBREAK,
        method_write_invert_DO_1
    }
}

MENU Group_fault_set_DO_1
{
    LABEL     "Set Fail Safe Values";
    ITEMS
    {
        func5_DO_1_fsafe_type,
        func5_DO_1_fsafe_value,
        func5_DO_1_fsafe_time,
        COLUMNBREAK,
        method_write_fail_DO_1
    }
}

MENU Group_batch_DO_1
{
    LABEL        "Define Batch Information";
    ITEMS
    {
        func5_DO_1_batch_id,
        func5_DO_1_batch_unit,
        func5_DO_1_batch_operation,
        func5_DO_1_batch_phase,
        COLUMNBREAK,
        method_write_batch_DO_1
    }
}

/*---------------------------------------------------------------------*/
/*    DO-1 : Methods                                                   */
/*---------------------------------------------------------------------*/

METHOD method_write_target_mode_DO_1
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_1_target_mode);
        ReadCommand(read_func5_DO_1_target_mode);
    }
}

METHOD method_write_channel_in_out_DO_1
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_1_in_channel);
        ReadCommand(read_func5_DO_1_in_channel);
        iassign(func5_DO_1_out_channel, func5_DO_1_in_channel);
        WriteCommand(write_func5_DO_1_out_channel);
        ReadCommand(read_func5_DO_1_out_channel);
    }
}

METHOD method_write_channel_out_DO_1
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_1_out_channel);
        ReadCommand(read_func5_DO_1_out_channel);
    }
}

METHOD method_write_invert_DO_1
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_1_invert);
        ReadCommand(read_func5_DO_1_invert);
    }
}


METHOD method_write_scale_in_DO_1
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_1_pv);
        ReadCommand(read_func5_DO_1_pv);
    }
}

METHOD method_write_scale_out_DO_1
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_1_out_scale);
        ReadCommand(read_func5_DO_1_out_scale);
    }
}

METHOD method_write_fail_DO_1
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_1_fsafe_type);
        WriteCommand(write_func5_DO_1_fsafe_time);
        WriteCommand(write_func5_DO_1_fsafe_value);
        ReadCommand(read_func5_DO_1_fsafe_type);
        ReadCommand(read_func5_DO_1_fsafe_time);
        ReadCommand(read_func5_DO_1_fsafe_value);
    }
}

METHOD method_write_batch_DO_1
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_1_batch_information);
    }
}

METHOD method_set_status_limit_func5_DO_1
{
    CLASS        INPUT;
    LABEL       "set status limit";
    DEFINITION
    {
        int    quality;
        int block_mode;

        quality = ivar_value(func5_DO_1_setpoint_status_quality);
        if ((quality == 0x20) || (quality == 0x30))
            iassign(func5_DO_1_setpoint_status_limit, 0);

        quality = ivar_value(func5_DO_1_rcas_in_status_quality);
        if ((quality == 0x20) || (quality == 0x30))
            iassign(func5_DO_1_rcas_in_status_limit, 0);

        quality = ivar_value(func5_DO_1_simulate_status_quality);
        if ((quality == 0x20) || (quality == 0x30))
            iassign(func5_DO_1_simulate_status_limit, 0);

        block_mode    = ivar_value(func5_DO_1_target_mode);
        quality        = ivar_value(func5_DO_1_out_status_quality);
        if (((block_mode == BLOCK_MODE_MAN) || (block_mode == BLOCK_MODE_LO)) && ((quality == 0x20) || (quality == 0x30)))
            iassign(func5_DO_1_out_status_limit, 0);
    }
}

/***********************************************************************/
/*    DO Function Block 2                                              */
/***********************************************************************/

BLOCK func5_DO_2_block
{
    TYPE    FUNCTION;
    NUMBER    14;
}

func5_DO_2_blk_reserve                      LIKE VARIABLE    phys_blk_reserve
{
}

VARIABLE func5_DO_2_blk_object
{
    LABEL       [blk_block_object];
    HELP        [blk_block_object_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    2,    [blk_block_object_FUNCTION]        }
    }
    HANDLING    READ;
}

VARIABLE func5_DO_2_blk_parent_class
{
    LABEL       [blk_parent_class];
    HELP        [func_blk_parent_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    2,    [func_blk_parent_class_OUTPUT]    }
    }
    HANDLING    READ;
}

VARIABLE func5_DO_2_blk_class
{
    LABEL       [blk_class];
    HELP        [func_blk_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    2,      [func_blk_class_DO]      },
        {    250,    [not_used]               },
        {    251,    [none]                   },
        {    252,    [unknown]                },
        {    253,    [special]                }
    }
    HANDLING    READ;
}

func5_DO_2_blk_dd_reference                 LIKE VARIABLE    phys_blk_dd_reference
{
}

func5_DO_2_blk_dd_rev                       LIKE VARIABLE    phys_blk_dd_rev
{
}

func5_DO_2_blk_profile                      LIKE VARIABLE    phys_blk_profile
{
}

func5_DO_2_blk_profile_rev                  LIKE VARIABLE    phys_blk_profile_rev
{
}

func5_DO_2_blk_execution_time               LIKE VARIABLE    phys_blk_execution_time
{
}

func5_DO_2_blk_num_parameters               LIKE VARIABLE    phys_blk_num_parameters
{
}

func5_DO_2_blk_index_view_1                 LIKE VARIABLE    phys_blk_index_view_1
{
}

func5_DO_2_blk_num_view_lists               LIKE VARIABLE    phys_blk_num_view_lists
{
}

func5_DO_2_st_rev                           LIKE VARIABLE    phys_st_rev
{
}

func5_DO_2_tag_desc                         LIKE VARIABLE    phys_tag_desc
{
    REDEFINE LABEL        [MC_DO_2_tag_desc];
    TYPE                  ASCII (32)
    {
        REDEFINE DEFAULT_VALUE  "";
    }
}

func5_DO_2_strategy                         LIKE VARIABLE    phys_strategy
{
}

func5_DO_2_alert_key                        LIKE VARIABLE    phys_alert_key
{
}

VARIABLE func5_DO_2_target_mode
{
    LABEL       [target_mode];
    HELP        [target_mode_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x02,    [mode_RCAS]              },
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x20,    [mode_LO]                },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_2_actual_mode
{
    LABEL       [actual_mode];
    HELP        [actual_mode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x02,    [mode_RCAS]              },
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x20,    [mode_LO]                },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE func5_DO_2_permitted_mode
{
    LABEL       [permitted_mode];
    HELP        [permitted_mode_help];
    CLASS       CONTAINED;
    TYPE        BIT_ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x02,    [mode_RCAS]              },
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x20,    [mode_LO]                },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE func5_DO_2_normal_mode
{
    LABEL       [normal_mode];
    HELP        [normal_mode_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x02,    [mode_RCAS]              },
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x20,    [mode_LO]                },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

func5_DO_2_current_state_alarm_sum          LIKE VARIABLE    phys_current_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func5_DO_2_unacknowledged_state_alarm_sum   LIKE VARIABLE    phys_unacknowledged_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func5_DO_2_unreported_state_alarm_sum       LIKE VARIABLE    phys_unreported_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func5_DO_2_disabled_state_alarm_sum         LIKE VARIABLE    phys_disabled_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

VARIABLE func5_DO_2_batch_id
{
    LABEL       [func_batch_id];
    HELP        [func_batch_id_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (4)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_2_batch_unit
{
    LABEL       [func_batch_unit];
    HELP        [func_batch_unit_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_2_batch_operation
{
    LABEL       [func_batch_operation];
    HELP        [func_batch_operation_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_2_batch_phase
{
    LABEL       [func_batch_phase];
    HELP        [func_batch_phase_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

/*---------------------------------------------------------------------*/
/*    DO-2 : Additional Parameter                                      */
/*---------------------------------------------------------------------*/

VARIABLE func5_DO_2_setpoint_value
{
    LABEL       [func_ao_setpoint_value];
    HELP        [func_ao_setpoint_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_2_setpoint_status_quality
{
    LABEL       [status_quality];
    HELP        [func_ao_setpoint_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_INPUT_NO_RCAS
    }
    POST_EDIT_ACTIONS
    {
        method_set_status_limit_func5_DO_2
    }
    HANDLING    READ & WRITE;
}

func5_DO_2_setpoint_status_limit            LIKE VARIABLE    func5_DO_2_setpoint_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_INPUT_LIMIT (func5_DO_2_setpoint_status_quality)
    }
}

VARIABLE func5_DO_2_out_value
{
    LABEL       [func_out_value];
    HELP        [func_ao_out_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING
        IF ((func5_DO_2_target_mode == BLOCK_MODE_MAN) || (func5_DO_2_target_mode == BLOCK_MODE_LO))
        {
            READ & WRITE;
        }
        ELSE {
            READ;
        }
}

VARIABLE func5_DO_2_out_status_quality
{
    LABEL       [status_quality];
    HELP        [func_out_status_help];
    CLASS        OUTPUT & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        IF ((func5_DO_2_target_mode == BLOCK_MODE_MAN) || (func5_DO_2_target_mode == BLOCK_MODE_LO))
        {
            STATUS_INPUT_NO_RCAS
        }
        ELSE {
            STATUS_OUTPUT_NO_RCAS
        }
    }
    POST_EDIT_ACTIONS
    {
        IF ((func5_DO_2_target_mode == BLOCK_MODE_MAN) || (func5_DO_2_target_mode == BLOCK_MODE_LO))
        {
            method_set_status_limit_func5_DO_2
        }
    }
    HANDLING
        IF ((func5_DO_2_target_mode == BLOCK_MODE_MAN) || (func5_DO_2_target_mode == BLOCK_MODE_LO))
        {
            READ & WRITE;
        }
        ELSE {
            READ;
        }
}

func5_DO_2_out_status_limit                 LIKE VARIABLE    func5_DO_2_out_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func5_DO_2_out_status_quality)
    }
}

VARIABLE func5_DO_2_readback_value
{
    LABEL       [func_do_readback_value];
    HELP        [func_do_readback_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ;
}

VARIABLE func5_DO_2_readback_status_quality
{
    LABEL       [status_quality];
    HELP        [func_do_readback_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_NO_RCAS
    }
    HANDLING    READ;
}

func5_DO_2_readback_status_limit            LIKE VARIABLE    func5_DO_2_readback_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func5_DO_2_rcas_in_value
{
    LABEL       [func_rcas_in_value];
    HELP        [func_rcas_in_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_2_rcas_in_status_quality
{
    LABEL       [status_quality];
    HELP        [func_rcas_in_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_INPUT_RCAS
    }
    POST_EDIT_ACTIONS
    {
        method_set_status_limit_func5_DO_2
    }
    HANDLING    READ & WRITE;
}

func5_DO_2_rcas_in_status_limit             LIKE VARIABLE    func5_DO_2_rcas_in_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func5_DO_2_rcas_in_status_quality)
    }
}

VARIABLE func5_DO_2_in_channel
{
    LABEL       [func_channel];
    HELP        [func_channel_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE   2;
        {1,    "Mod_Out_D_1(TB)"              },
        {2,    "Mod_Out_D_2(TB)"              },
        {3,    "Mod_Out_D_3(TB)"              },
        {4,    "Mod_Out_D_4(TB)"              }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_2_invert
{
    LABEL       [func_invert];
    HELP        [func_invert_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [func_invert_NOT_INVERT]    },
        {    1,    [func_invert_INVERT]        }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_2_fsafe_time
{
    LABEL       [func_ao_fsafe_time];
    HELP        [func_ao_fsafe_time_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE    0.0;
    }
    CONSTANT_UNIT    [sec];
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_2_fsafe_type
{
    LABEL       [func_ao_fsafe_type];
    HELP        [func_ao_fsafe_type_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    2;
        {    0,    [func_ao_fsafe_type_FAIL_SAFE_VALUE]        },
        {    1,    [func_ao_fsafe_type_STORING_LAST_SETPOINT]  },
        {    2,    [func_ao_fsafe_type_FAIL_SAFE_POSITION]     }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_2_fsafe_value
{
    LABEL       [func_do_fsafe_value];
    HELP        [func_do_fsafe_value_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING        READ & WRITE;
}

VARIABLE func5_DO_2_rcas_out_value
{
    LABEL       [func_rcas_out_value];
    HELP        [func_rcas_out_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
}

VARIABLE func5_DO_2_rcas_out_status_quality
{
    LABEL       [status_quality];
    HELP        [func_rcas_out_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_RCAS
    }
    HANDLING    READ;
}

func5_DO_2_rcas_out_status_limit            LIKE VARIABLE    func5_DO_2_rcas_out_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func5_DO_2_simulate_value
{
    LABEL       [func_simulate_value];
    HELP        [func_ao_simulate_value_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_2_simulate_status_quality
{
    LABEL       [status_quality];
    HELP        [func_simulate_status_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_INPUT_NO_RCAS
    }
    POST_EDIT_ACTIONS
    {
        method_set_status_limit_func5_DO_2
    }
    HANDLING    READ & WRITE;
}

func5_DO_2_simulate_status_limit            LIKE VARIABLE    func5_DO_2_simulate_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func5_DO_2_simulate_status_quality)
    }
}

VARIABLE func5_DO_2_simulation_enabled
{
    LABEL       [func_simulation_enabled];
    HELP        [func_simulation_enabled_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        {    0,    [disabled]        },
        {    1,    [enabled]        }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_2_check_back
{
    LABEL       [func_check_back];
    HELP        [func_check_back_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        BIT_ENUMERATED (3)
    {
        {    0,                      [dia_OK],                [dia_OK_help]                },
        {    CB_FAIL_SAFE,           [cb_FAIL_SAFE],          [cb_FAIL_SAFE_help]          },
        {    CB_REQ_LOC_OP,          [cb_REQ_LOC_OP],         [cb_REQ_LOC_OP_help]         },
        {    CB_LOCAL_OP,            [cb_LOCAL_OP],           [cb_LOCAL_OP_help]           },
        {    CB_OVERRIDE,            [cb_OVERRIDE],           [cb_OVERRIDE_help]           },
        {    CB_DISC_DIR,            [cb_DISC_DIR],           [cb_DISC_DIR_help]           },
        {    CB_TORQUE_D_OP,         [cb_TORQUE_D_OP],        [cb_TORQUE_D_OP_help]        },
        {    CB_TORQUE_D_CL,         [cb_TORQUE_D_CL],        [cb_TORQUE_D_CL_help]        },
        {    CB_TRAV_TIME,           [cb_TRAV_TIME],          [cb_TRAV_TIME_help]          },
        {    CB_ACT_OPEN,            [cb_ACT_OPEN],           [cb_ACT_OPEN_help]           },
        {    CB_ACT_CLOSE,           [cb_ACT_CLOSE],          [cb_ACT_CLOSE_help]          },
        {    CB_UPDATE_EVT,          [cb_UPDATE_EVT],         [cb_UPDATE_EVT_help]         },
        {    CB_SIMULATE,            [cb_SIMULATE],           [cb_SIMULATE_help]           },
        {    CB_DISTURBANCE,         [cb_DISTURBANCE],        [cb_DISTURBANCE_help]        },
        {    CB_CONTR_ERR,           [cb_CONTR_ERR],          [cb_CONTR_ERR_help]          },
        {    CB_CONTR_INACT,         [cb_CONTR_INACT],        [cb_CONTR_INACT_help]        },
        {    CB_SELFTEST,            [cb_SELFTEST],           [cb_SELFTEST_help]           },
        {    CB_TOT_VALVE_TRAV,      [cb_TOT_VALVE_TRAV],     [cb_TOT_VALVE_TRAV_help]     },
        {    CB_BREAK_TIME_UNDER,    [cb_BREAK_TIME_UNDER],   [cb_BREAK_TIME_UNDER_help]   },
        {    CB_BREAK_TIME_OVER,     [cb_BREAK_TIME_OVER],    [cb_BREAK_TIME_OVER_help]    },
        {    CB_CYCLE_TEST,          [cb_CYCLE_TEST],         [cb_CYCLE_TEST_help]         },
        {    CB_TRAVEL_TIME_UNDER,   [cb_TRAVEL_TIME_UNDER],  [cb_TRAVEL_TIME_UNDER_help]  },
        {    CB_TRAVEL_TIME_OVER,    [cb_TRAVEL_TIME_OVER],   [cb_TRAVEL_TIME_OVER_help]   }
    }
    HANDLING    READ;
    STYLE      "MULTILINE 10 8" ;
}

VARIABLE func5_DO_2_check_back_mask
{
    LABEL       [func_check_back_mask];
    HELP        [func_check_back_mask_help];
    CLASS       CONTAINED;
    TYPE        BIT_ENUMERATED (3)
    {
        {    CB_FAIL_SAFE,           [cb_FAIL_SAFE],          [cb_FAIL_SAFE_help]          },
        {    CB_REQ_LOC_OP,          [cb_REQ_LOC_OP],         [cb_REQ_LOC_OP_help]         },
        {    CB_LOCAL_OP,            [cb_LOCAL_OP],           [cb_LOCAL_OP_help]           },
        {    CB_OVERRIDE,            [cb_OVERRIDE],           [cb_OVERRIDE_help]           },
        {    CB_DISC_DIR,            [cb_DISC_DIR],           [cb_DISC_DIR_help]           },
        {    CB_TORQUE_D_OP,         [cb_TORQUE_D_OP],        [cb_TORQUE_D_OP_help]        },
        {    CB_TORQUE_D_CL,         [cb_TORQUE_D_CL],        [cb_TORQUE_D_CL_help]        },
        {    CB_TRAV_TIME,           [cb_TRAV_TIME],          [cb_TRAV_TIME_help]          },
        {    CB_ACT_OPEN,            [cb_ACT_OPEN],           [cb_ACT_OPEN_help]           },
        {    CB_ACT_CLOSE,           [cb_ACT_CLOSE],          [cb_ACT_CLOSE_help]          },
        {    CB_UPDATE_EVT,          [cb_UPDATE_EVT],         [cb_UPDATE_EVT_help]         },
        {    CB_SIMULATE,            [cb_SIMULATE],           [cb_SIMULATE_help]           },
        {    CB_DISTURBANCE,         [cb_DISTURBANCE],        [cb_DISTURBANCE_help]        },
        {    CB_CONTR_ERR,           [cb_CONTR_ERR],          [cb_CONTR_ERR_help]          },
        {    CB_CONTR_INACT,         [cb_CONTR_INACT],        [cb_CONTR_INACT_help]        },
        {    CB_SELFTEST,            [cb_SELFTEST],           [cb_SELFTEST_help]           },
        {    CB_TOT_VALVE_TRAV,      [cb_TOT_VALVE_TRAV],     [cb_TOT_VALVE_TRAV_help]     },
        {    CB_BREAK_TIME_UNDER,    [cb_BREAK_TIME_UNDER],   [cb_BREAK_TIME_UNDER_help]   },
        {    CB_BREAK_TIME_OVER,     [cb_BREAK_TIME_OVER],    [cb_BREAK_TIME_OVER_help]    },
        {    CB_CYCLE_TEST,          [cb_CYCLE_TEST],         [cb_CYCLE_TEST_help]         },
        {    CB_TRAVEL_TIME_UNDER,   [cb_TRAVEL_TIME_UNDER],  [cb_TRAVEL_TIME_UNDER_help]  },
        {    CB_TRAVEL_TIME_OVER,    [cb_TRAVEL_TIME_OVER],   [cb_TRAVEL_TIME_OVER_help]   }
    }
    HANDLING    READ;
    STYLE      "MULTILINE 10 8" ;
}

func5_DO_2_out_channel                      LIKE VARIABLE    func5_DO_2_in_channel
{
}

/***********************************************************************/
/*    DO-2 : COMMAND                                                   */
/***********************************************************************/

COMMAND read_func5_DO_2_blk
{
    BLOCK func5_DO_2_block;
    INDEX 0;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_2_blk_reserve,        func5_DO_2_blk_object,
            func5_DO_2_blk_parent_class,   func5_DO_2_blk_class,
            func5_DO_2_blk_dd_reference,   func5_DO_2_blk_dd_rev,
            func5_DO_2_blk_profile,        func5_DO_2_blk_profile_rev,
            func5_DO_2_blk_execution_time, func5_DO_2_blk_num_parameters,
            func5_DO_2_blk_index_view_1,   func5_DO_2_blk_num_view_lists
        }
    }
}

COMMAND read_func5_DO_2_st_rev
{
    BLOCK func5_DO_2_block;
    INDEX 1;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_2_st_rev
        }
    }
}

COMMAND read_func5_DO_2_tag_desc
{
    BLOCK func5_DO_2_block;
    INDEX 2;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_2_tag_desc
        }
    }
}

COMMAND write_func5_DO_2_tag_desc
{
    BLOCK func5_DO_2_block;
    INDEX 2;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_2_tag_desc
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_2_strategy
{
    BLOCK func5_DO_2_block;
    INDEX 3;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_2_strategy
        }
    }
}

COMMAND write_func5_DO_2_strategy
{
    BLOCK func5_DO_2_block;
    INDEX 3;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_2_strategy
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_2_alert_key
{
    BLOCK func5_DO_2_block;
    INDEX 4;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_2_alert_key
        }
    }
}

COMMAND write_func5_DO_2_alert_key
{
    BLOCK func5_DO_2_block;
    INDEX 4;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_2_alert_key
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_2_target_mode
{
    BLOCK func5_DO_2_block;
    INDEX 5;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_2_target_mode
        }
    }
}

COMMAND write_func5_DO_2_target_mode
{
    BLOCK func5_DO_2_block;
    INDEX 5;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_2_target_mode
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_2_mode
{
    BLOCK func5_DO_2_block;
    INDEX 6;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             func5_DO_2_actual_mode, func5_DO_2_permitted_mode, func5_DO_2_normal_mode
        }
    }
}

COMMAND read_func5_DO_2_alarm
{
    BLOCK func5_DO_2_block;
    INDEX 7;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_2_current_state_alarm_sum, func5_DO_2_unacknowledged_state_alarm_sum,
            func5_DO_2_unreported_state_alarm_sum, func5_DO_2_disabled_state_alarm_sum
        }
    }
}

COMMAND read_func5_DO_2_batch_information
{
    BLOCK func5_DO_2_block;
    INDEX 8;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_2_batch_id, func5_DO_2_batch_unit, func5_DO_2_batch_operation, func5_DO_2_batch_phase
        }
    }
}

COMMAND write_func5_DO_2_batch_information
{
    BLOCK func5_DO_2_block;
    INDEX 8;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_2_batch_id, func5_DO_2_batch_unit, func5_DO_2_batch_operation, func5_DO_2_batch_phase
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_2_setpoint
{
    BLOCK func5_DO_2_block;
    INDEX 9;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_2_setpoint_value,
            func5_DO_2_setpoint_status_quality    <0xFC>,
            func5_DO_2_setpoint_status_limit      <0x03>
        }
    }
}

COMMAND write_func5_DO_2_setpoint
{
    BLOCK func5_DO_2_block;
    INDEX 9;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_2_setpoint_value,
            func5_DO_2_setpoint_status_quality    <0xFC>,
            func5_DO_2_setpoint_status_limit      <0x03>
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_2_out
{
    BLOCK func5_DO_2_block;
    INDEX 10;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_2_out_value,
            func5_DO_2_out_status_quality      <0xFC>,
            func5_DO_2_out_status_limit        <0x03>
        }
    }
}

COMMAND write_func5_DO_2_out
{
    BLOCK func5_DO_2_block;
    INDEX 10;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_2_out_value,
            func5_DO_2_out_status_quality      <0xFC>,
            func5_DO_2_out_status_limit        <0x03>
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_2_readback
{
    BLOCK func5_DO_2_block;
    INDEX 12;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_2_readback_value,
            func5_DO_2_readback_status_quality    <0xFC>,
            func5_DO_2_readback_status_limit      <0x03>
        }
    }
}

COMMAND read_func5_DO_2_rcas_in
{
    BLOCK func5_DO_2_block;
    INDEX 14;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_2_rcas_in_value,
            func5_DO_2_rcas_in_status_quality      <0xFC>,
            func5_DO_2_rcas_in_status_limit        <0x03>
        }
    }
}

COMMAND write_func5_DO_2_rcas_in
{
    BLOCK func5_DO_2_block;
    INDEX 14;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_2_rcas_in_value,
            func5_DO_2_rcas_in_status_quality      <0xFC>,
            func5_DO_2_rcas_in_status_limit        <0x03>
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_2_in_channel
{
    BLOCK func5_DO_2_block;
    INDEX 17;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_2_in_channel
        }
    }
}

COMMAND write_func5_DO_2_in_channel
{
    BLOCK func5_DO_2_block;
    INDEX 17;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_2_in_channel
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_2_invert
{
    BLOCK func5_DO_2_block;
    INDEX 18;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_2_invert
        }
    }
}

COMMAND write_func5_DO_2_invert
{
    BLOCK func5_DO_2_block;
    INDEX 18;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_2_invert
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_2_fsafe_time
{
    BLOCK func5_DO_2_block;
    INDEX 19;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_2_fsafe_time
        }
    }
}

COMMAND write_func5_DO_2_fsafe_time
{
    BLOCK func5_DO_2_block;
    INDEX 19;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_2_fsafe_time
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_2_fsafe_type
{
    BLOCK func5_DO_2_block;
    INDEX 20;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_2_fsafe_type
        }
    }
}

COMMAND write_func5_DO_2_fsafe_type
{
    BLOCK func5_DO_2_block;
    INDEX 20;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_2_fsafe_type
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_2_fsafe_value
{
    BLOCK func5_DO_2_block;
    INDEX 21;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_2_fsafe_value
        }
    }
}

COMMAND write_func5_DO_2_fsafe_value
{
    BLOCK func5_DO_2_block;
    INDEX 21;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_2_fsafe_value
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_2_rcas_out_value
{
    BLOCK func5_DO_2_block;
    INDEX 22;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_2_rcas_out_value,
            func5_DO_2_rcas_out_status_quality    <0xFC>,
            func5_DO_2_rcas_out_status_limit      <0x03>

        }
    }
}

COMMAND read_func5_DO_2_simulate
{
    BLOCK func5_DO_2_block;
    INDEX 24;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_2_simulate_status_quality    <0xFC>,
            func5_DO_2_simulate_status_limit      <0x03>,
            func5_DO_2_simulate_value,
            func5_DO_2_simulation_enabled
        }
    }
}

COMMAND write_func5_DO_2_simulate
{
    BLOCK func5_DO_2_block;
    INDEX 24;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_2_simulate_status_quality    <0xFC>,
            func5_DO_2_simulate_status_limit      <0x03>,
            func5_DO_2_simulate_value,
            func5_DO_2_simulation_enabled
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_2_check_back
{
    BLOCK func5_DO_2_block;
    INDEX 33;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_2_check_back
        }
    }
}

COMMAND read_func5_DO_2_check_back_mask
{
    BLOCK func5_DO_2_block;
    INDEX 34;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_2_check_back_mask
        }
    }
}

COMMAND read_func5_DO_2_out_channel
{
    BLOCK func5_DO_2_block;
    INDEX 35;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_2_out_channel
        }
    }
}

COMMAND write_func5_DO_2_out_channel
{
    BLOCK func5_DO_2_block;
    INDEX 35;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_2_out_channel
        }
        REPLY
        {
        }
    }
}

/***********************************************************************/
/*    DO-2 : MENUs                                                     */
/***********************************************************************/

MENU Tab_s_func5_DO_2
{
    LABEL        "DO-2";
    ITEMS
    {
        func5_DO_2_st_rev,
        //func5_DO_2_in_channel,
        func5_DO_2_out_channel,
        func5_DO_2_invert,
        Tab_s_func5_DO_2_batch,
        Tab_s_func5_DO_2_fsafe
    }
}

MENU Tab_m_func5_DO_2
{
    LABEL       [MT_DO_2];
    ITEMS
    {
        func5_DO_2_st_rev,
        //func5_DO_2_in_channel (READ_ONLY),
        func5_DO_2_out_channel (READ_ONLY),
        func5_DO_2_invert      (READ_ONLY),
        Tab_s_func5_DO_2_batch,
        Tab_m_func5_DO_2_fsafe
    }
}

MENU Tab_s_func5_DO_2_batch
{
    LABEL       [menu_ident_batch_info];
    ITEMS
    {
        func5_DO_2_batch_id,
        func5_DO_2_batch_unit,
        func5_DO_2_batch_operation,
        func5_DO_2_batch_phase
    }
}

MENU Tab_s_func5_DO_2_fsafe
{
    LABEL       [menu_fail_safe] ;
    ITEMS
    {
        func5_DO_2_fsafe_type,
        func5_DO_2_fsafe_time,
        func5_DO_2_fsafe_value
    }
}

MENU Tab_m_func5_DO_2_fsafe
{
    LABEL       [menu_fail_safe] ;
    ITEMS
    {
        func5_DO_2_fsafe_type  (READ_ONLY),
        func5_DO_2_fsafe_time  (READ_ONLY),
        func5_DO_2_fsafe_value (READ_ONLY)
    }
}

/*---------------------------------------------------------------------*/
/*    DO-2 : Online-Windows                                            */
/*---------------------------------------------------------------------*/

MENU Page_display_measure_func5_DO_2
{
    LABEL        "DO-2";
    ITEMS
    {
        Group_display_readback_func5_DO_2,
        Group_display_setpoint_func5_DO_2,
        func5_DO_2_check_back,
        Group_display_out_func5_DO_2
    }
}

MENU Group_display_out_func5_DO_2
{
    LABEL       [func_out_value];
    ITEMS
    {
        func5_DO_2_out_value               (READ_ONLY),
        COLUMNBREAK,
        func5_DO_2_out_status_quality      (READ_ONLY),
        func5_DO_2_out_status_limit        (READ_ONLY)
    }
}

MENU Group_display_readback_func5_DO_2
{
    LABEL       [func_ao_readback_value];
    ITEMS
    {
        func5_DO_2_readback_value,
        COLUMNBREAK,
        func5_DO_2_readback_status_quality,
        func5_DO_2_readback_status_limit
    }
}

MENU Group_display_setpoint_func5_DO_2
{
    LABEL       [func_ao_setpoint_value];
    ITEMS
    {
        func5_DO_2_setpoint_value             (READ_ONLY),
        COLUMNBREAK,
        func5_DO_2_setpoint_status_quality    (READ_ONLY),
        func5_DO_2_setpoint_status_limit      (READ_ONLY)
    }
}

MENU OnlineWindow_S_alarm_func5_DO_2
{
    LABEL        "DO-2";
    ITEMS
    {
        Page_alarm_sum_func5_DO_2
    }
}

MENU Page_alarm_sum_func5_DO_2
{
    LABEL       [menu_dialog_alarm_sum];
    ITEMS
    {
        func5_DO_2_current_state_alarm_sum,
        func5_DO_2_unreported_state_alarm_sum
    }
}

/*---------------------------------------------------------------------*/
/*    DO-2 : Online-Dialogs                                            */
/*---------------------------------------------------------------------*/

MENU OnlineDialog_operation_func5_DO_2
{
    LABEL        "DO-2";
    ITEMS
    {
        Page_operation_AUTO_func5_DO_2,
        Page_operation_RCAS_func5_DO_2,
        Page_operation_MAN_func5_DO_2,
        Page_simulation_func5_DO_2
    }
}

MENU Page_operation_AUTO_func5_DO_2
{
    LABEL       [mode_AUTO];
    ITEMS
    {
        func5_DO_2_target_mode,
        func5_DO_2_actual_mode,
        Group_setpoint_DO_func5_DO_2,
        Group_readback_func5_DO_2,
        func5_DO_2_check_back,
        method_set
    }
}

MENU Page_operation_RCAS_func5_DO_2
{
    LABEL       [mode_RCAS];
    ITEMS
    {
        func5_DO_2_target_mode,
        func5_DO_2_actual_mode,
        Group_rcas_in_DO_func5_DO_2,
        Group_rcas_out_DO_func5_DO_2,
        Group_readback_func5_DO_2,
        func5_DO_2_check_back,
        method_set
    }
}

MENU Page_operation_MAN_func5_DO_2
{
    LABEL       [mode_MAN];
    ITEMS
    {
        func5_DO_2_target_mode,
        func5_DO_2_actual_mode,
        Group_out_func5_DO_2,
        Group_readback_func5_DO_2,
        func5_DO_2_check_back,
        method_set
    }
}

MENU Page_simulation_func5_DO_2
{
    LABEL       [menu_dialog_simulation];
    ITEMS
    {
        func5_DO_2_simulation_enabled,
        Group_simulation_func5_DO_2,
        func5_DO_2_check_back,
        method_set
    }
}

MENU Group_setpoint_DO_func5_DO_2
{
    LABEL       [func_ao_setpoint_value];
    ITEMS
    {
        func5_DO_2_setpoint_value,
        COLUMNBREAK,
        func5_DO_2_setpoint_status_quality,
        func5_DO_2_setpoint_status_limit
    }
}

MENU Group_readback_func5_DO_2
{
    LABEL       [func_ao_readback_value];
    ITEMS
    {
        func5_DO_2_readback_value,
        COLUMNBREAK,
        func5_DO_2_readback_status_quality,
        func5_DO_2_readback_status_limit
    }
}

MENU Group_rcas_in_DO_func5_DO_2
{
    LABEL       [func_rcas_in_value];
    ITEMS
    {
        func5_DO_2_rcas_in_value,
        COLUMNBREAK,
        func5_DO_2_rcas_in_status_quality,
        func5_DO_2_rcas_in_status_limit
    }
}

MENU Group_rcas_out_DO_func5_DO_2
{
    LABEL       [func_rcas_out_value];
    ITEMS
    {
        func5_DO_2_rcas_out_value,
        COLUMNBREAK,
        func5_DO_2_rcas_out_status_quality,
        func5_DO_2_rcas_out_status_limit
    }
}

MENU Group_out_func5_DO_2
{
    LABEL       [menu_output];
    ITEMS
    {
        func5_DO_2_out_value,
        COLUMNBREAK,
        func5_DO_2_out_status_quality,
        func5_DO_2_out_status_limit
    }
}

MENU Group_simulation_func5_DO_2
{
    LABEL       [menu_dialog_simulation];
    ITEMS
    {
        func5_DO_2_simulate_value,
        COLUMNBREAK,
        func5_DO_2_simulate_status_quality,
        func5_DO_2_simulate_status_limit
    }
}

MENU Page_diagnosis_func5_DO_2
{
    LABEL        "DO-2";
    ITEMS
    {
        func5_DO_2_blk_object,
        func5_DO_2_blk_parent_class,
        func5_DO_2_blk_class,
        func5_DO_2_blk_dd_reference,
        func5_DO_2_blk_dd_rev,
        func5_DO_2_blk_profile,
        func5_DO_2_blk_profile_rev,
        func5_DO_2_st_rev,
        func5_DO_2_actual_mode,
        func5_DO_2_simulation_enabled (READ_ONLY)
    }
}

MENU OnlineDialog_DO_2_setting
{
    LABEL        "DO-2 Block Mode";
    ITEMS
    {
        Page_mode_DO_2
        Page_actuator_DO_2
    }
}

MENU Page_mode_DO_2
{
    LABEL        "Config Block Mode";
    ITEMS
    {
        Group_mode_DO_2,
        Group_output_DO_2,
        Group_setpoint_DO_2,
        Group_rcas_in_DO_2,
        Group_rcas_out_DO_2,
        method_set
    }
}

MENU Group_mode_DO_2
{
    LABEL        "Config Block Mode";
    ITEMS
    {
        func5_DO_2_target_mode,
        COLUMNBREAK,
        func5_DO_2_actual_mode
    }
}

MENU Group_output_DO_2
{
    LABEL        "Set Output (MAN)"; /* [func_out_value]; */
    ITEMS
    {
        func5_DO_2_out_value,
        COLUMNBREAK,
        func5_DO_2_out_status_quality,
        func5_DO_2_out_status_limit
    }
}

MENU Group_setpoint_DO_2
{
    LABEL        "Set Setpoint from Operator - SP (AUTO)"; /* [func_out_value]; */
    ITEMS
    {
        func5_DO_2_setpoint_value,
        COLUMNBREAK,
        func5_DO_2_setpoint_status_quality,
        func5_DO_2_setpoint_status_limit
    }
}

MENU Group_rcas_in_DO_2
{
    LABEL        "Set Setpoint from Remote Station - RCAS_IN (RCAS)"; /* [func_out_value]; */
    ITEMS
    {
        func5_DO_2_rcas_in_value,
        COLUMNBREAK,
        func5_DO_2_rcas_in_status_quality,
        func5_DO_2_rcas_in_status_limit
    }
}

MENU Group_rcas_out_DO_2
{
    LABEL        "From RCAS_OUT to Remote Station"; /* [func_out_value]; */
    ITEMS
    {
        func5_DO_2_rcas_out_value,
        COLUMNBREAK,
        func5_DO_2_rcas_out_status_quality,
        func5_DO_2_rcas_out_status_limit
    }
}

MENU Page_actuator_DO_2
{
    LABEL        "Feedback";
    ITEMS
    {
        Group_readback_DO_2,
        func5_DO_2_check_back,
        func5_DO_2_current_state_alarm_sum
    }
}

MENU Group_readback_DO_2
{
    LABEL        "Readback to Transducer"; /* [func_out_value]; */
    ITEMS
    {
        func5_DO_2_readback_value,
        COLUMNBREAK,
        func5_DO_2_readback_status_quality,
        func5_DO_2_readback_status_limit
    }
}

MENU OnlineDialog_simulation_DO_2
{
    LABEL        "Simulate DO-2"; /* "Simulate AI"; */
    ITEMS
    {
        Page_simulation_DO_2,
        Page_simulation_out_DO_2
    }
}

MENU Page_simulation_DO_2
{
    LABEL        [menu_dialog_simulation_input];
    ITEMS
    {
        func5_DO_2_simulation_enabled,
        Group_simulate_value_DO_2,
        Group_readback_DO_2,
        method_set
    }
}

MENU Group_simulate_value_DO_2
{
    LABEL     "Simulation Value";
    ITEMS
    {
        func5_DO_2_simulate_value,
        COLUMNBREAK,
        func5_DO_2_simulate_status_quality,
        func5_DO_2_simulate_status_limit
    }
}

MENU Page_simulation_out_DO_2
{
    LABEL        [menu_dialog_simulation_output];
    ITEMS
    {
        Group_mode_DO_2,
        Group_output_DO_2,
        method_set
    }
}

/*---------------------------------------------------------------------*/
/*    DO-2 : Offline-Windows                                           */
/*---------------------------------------------------------------------*/

MENU OfflineWindow_DO_2_geral
{
    LABEL "DO-2"; 
    ITEMS
    {
        Page_basic_DO_2,
        Page_advanced_DO_2
    }
}

MENU Page_basic_DO_2
{
    LABEL [MC_Tab_basic];
    ITEMS
    {
        Group_target_mode_DO_2,
        Group_channel_DO_2,
        Group_Set_Invert_DO_2
    }
}

MENU Page_advanced_DO_2
{
    LABEL [MC_Tab_advanced];
    ITEMS
    {
        Group_fault_set_DO_2,
        Group_batch_DO_2
    }
}

MENU Page_batch_DO_2
{
    LABEL [MC_Batch_Info];
    ITEMS
    {
        Group_batch_DO_2
    }
}


MENU Group_target_mode_DO_2
{
    LABEL "Config Block Mode";
    ITEMS
    {
        func5_DO_2_target_mode,
        COLUMNBREAK,
        method_write_target_mode_DO_2
    }
}

MENU Group_channel_DO_2
{
    LABEL        "Select Channel";
    ITEMS
    {
        //func5_DO_2_in_channel,
        func5_DO_2_out_channel,
        COLUMNBREAK,
        method_write_channel_in_out_DO_2
    }
}

MENU Group_channel_out_DO_2
{
    LABEL        "Select Output";
    ITEMS
    {
        func5_DO_2_out_channel,
        COLUMNBREAK,
        method_write_channel_out_DO_2
    }
}

MENU Group_Set_Invert_DO_2
{
    LABEL "Set Invert Input Value";
    ITEMS
    {
        func5_DO_2_invert,
        COLUMNBREAK,
        method_write_invert_DO_2
    }
}

MENU Group_fault_set_DO_2
{
    LABEL     "Set Fail Safe Values";
    ITEMS
    {
        func5_DO_2_fsafe_type,
        func5_DO_2_fsafe_value,
        func5_DO_2_fsafe_time,
        COLUMNBREAK,
        method_write_fail_DO_2
    }
}

MENU Group_batch_DO_2
{
    LABEL        "Define Batch Information";
    ITEMS
    {
        func5_DO_2_batch_id,
        func5_DO_2_batch_unit,
        func5_DO_2_batch_operation,
        func5_DO_2_batch_phase,
        COLUMNBREAK,
        method_write_batch_DO_2
    }
}

/*---------------------------------------------------------------------*/
/*    DO-2 : Methods                                                   */
/*---------------------------------------------------------------------*/

METHOD method_write_target_mode_DO_2
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_2_target_mode);
        ReadCommand(read_func5_DO_2_target_mode);
    }
}

METHOD method_write_channel_in_out_DO_2
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_2_in_channel);
        ReadCommand(read_func5_DO_2_in_channel);
        iassign(func5_DO_2_out_channel, func5_DO_2_in_channel);
        WriteCommand(write_func5_DO_2_out_channel);
        ReadCommand(read_func5_DO_2_out_channel);
    }
}

METHOD method_write_channel_out_DO_2
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_2_out_channel);
        ReadCommand(read_func5_DO_2_out_channel);
    }
}

METHOD method_write_invert_DO_2
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_2_invert);
        ReadCommand(read_func5_DO_2_invert);
    }
}


METHOD method_write_scale_in_DO_2
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_2_pv);
        ReadCommand(read_func5_DO_2_pv);
    }
}

METHOD method_write_scale_out_DO_2
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_2_out_scale);
        ReadCommand(read_func5_DO_2_out_scale);
    }
}

METHOD method_write_fail_DO_2
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_2_fsafe_type);
        WriteCommand(write_func5_DO_2_fsafe_time);
        WriteCommand(write_func5_DO_2_fsafe_value);
        ReadCommand(read_func5_DO_2_fsafe_type);
        ReadCommand(read_func5_DO_2_fsafe_time);
        ReadCommand(read_func5_DO_2_fsafe_value);
    }
}

METHOD method_write_batch_DO_2
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_2_batch_information);
    }
}

METHOD method_set_status_limit_func5_DO_2
{
    CLASS        INPUT;
    LABEL       "set status limit";
    DEFINITION
    {
        int    quality;
        int block_mode;

        quality = ivar_value(func5_DO_2_setpoint_status_quality);
        if ((quality == 0x20) || (quality == 0x30))
            iassign(func5_DO_2_setpoint_status_limit, 0);

        quality = ivar_value(func5_DO_2_rcas_in_status_quality);
        if ((quality == 0x20) || (quality == 0x30))
            iassign(func5_DO_2_rcas_in_status_limit, 0);

        quality = ivar_value(func5_DO_2_simulate_status_quality);
        if ((quality == 0x20) || (quality == 0x30))
            iassign(func5_DO_2_simulate_status_limit, 0);

        block_mode    = ivar_value(func5_DO_2_target_mode);
        quality        = ivar_value(func5_DO_2_out_status_quality);
        if (((block_mode == BLOCK_MODE_MAN) || (block_mode == BLOCK_MODE_LO)) && ((quality == 0x20) || (quality == 0x30)))
            iassign(func5_DO_2_out_status_limit, 0);
    }
}

/***********************************************************************/
/*    DO Function Block 3                                               */
/***********************************************************************/

BLOCK func5_DO_3_block
{
    TYPE    FUNCTION;
    NUMBER    15;
}

func5_DO_3_blk_reserve                      LIKE VARIABLE    phys_blk_reserve
{
}

VARIABLE func5_DO_3_blk_object
{
    LABEL       [blk_block_object];
    HELP        [blk_block_object_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    2,    [blk_block_object_FUNCTION]        }
    }
    HANDLING    READ;
}

VARIABLE func5_DO_3_blk_parent_class
{
    LABEL       [blk_parent_class];
    HELP        [func_blk_parent_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    2,    [func_blk_parent_class_OUTPUT]    }
    }
    HANDLING    READ;
}

VARIABLE func5_DO_3_blk_class
{
    LABEL       [blk_class];
    HELP        [func_blk_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    2,      [func_blk_class_DO]      },
        {    250,    [not_used]               },
        {    251,    [none]                   },
        {    252,    [unknown]                },
        {    253,    [special]                }
    }
    HANDLING    READ;
}

func5_DO_3_blk_dd_reference               LIKE VARIABLE    phys_blk_dd_reference
{
}

func5_DO_3_blk_dd_rev                     LIKE VARIABLE    phys_blk_dd_rev
{
}

func5_DO_3_blk_profile                    LIKE VARIABLE    phys_blk_profile
{
}

func5_DO_3_blk_profile_rev                LIKE VARIABLE    phys_blk_profile_rev
{
}

func5_DO_3_blk_execution_time             LIKE VARIABLE    phys_blk_execution_time
{
}

func5_DO_3_blk_num_parameters             LIKE VARIABLE    phys_blk_num_parameters
{
}

func5_DO_3_blk_index_view_1               LIKE VARIABLE    phys_blk_index_view_1
{
}

func5_DO_3_blk_num_view_lists             LIKE VARIABLE    phys_blk_num_view_lists
{
}

func5_DO_3_st_rev                         LIKE VARIABLE    phys_st_rev
{
}

func5_DO_3_tag_desc                       LIKE VARIABLE    phys_tag_desc
{
    REDEFINE LABEL        [MC_DO_3_tag_desc];
    TYPE                  ASCII (32)
    {
        REDEFINE DEFAULT_VALUE  "";
    }
}

func5_DO_3_strategy                       LIKE VARIABLE    phys_strategy
{
}

func5_DO_3_alert_key                      LIKE VARIABLE    phys_alert_key
{
}

VARIABLE func5_DO_3_target_mode
{
    LABEL       [target_mode];
    HELP        [target_mode_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x02,    [mode_RCAS]              },
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x20,    [mode_LO]                },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_3_actual_mode
{
    LABEL       [actual_mode];
    HELP        [actual_mode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x02,    [mode_RCAS]              },
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x20,    [mode_LO]                },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE func5_DO_3_permitted_mode
{
    LABEL       [permitted_mode];
    HELP        [permitted_mode_help];
    CLASS       CONTAINED;
    TYPE        BIT_ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x02,    [mode_RCAS]              },
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x20,    [mode_LO]                },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE func5_DO_3_normal_mode
{
    LABEL       [normal_mode];
    HELP        [normal_mode_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x02,    [mode_RCAS]              },
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x20,    [mode_LO]                },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

func5_DO_3_current_state_alarm_sum        LIKE VARIABLE    phys_current_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func5_DO_3_unacknowledged_state_alarm_sum LIKE VARIABLE    phys_unacknowledged_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func5_DO_3_unreported_state_alarm_sum     LIKE VARIABLE    phys_unreported_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func5_DO_3_disabled_state_alarm_sum       LIKE VARIABLE    phys_disabled_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

VARIABLE func5_DO_3_batch_id
{
    LABEL       [func_batch_id];
    HELP        [func_batch_id_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (4)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_3_batch_unit
{
    LABEL       [func_batch_unit];
    HELP        [func_batch_unit_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_3_batch_operation
{
    LABEL       [func_batch_operation];
    HELP        [func_batch_operation_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_3_batch_phase
{
    LABEL       [func_batch_phase];
    HELP        [func_batch_phase_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

/*---------------------------------------------------------------------*/
/*    DO-3 : Additional Parameter                                      */
/*---------------------------------------------------------------------*/

VARIABLE func5_DO_3_setpoint_value
{
    LABEL       [func_ao_setpoint_value];
    HELP        [func_ao_setpoint_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_3_setpoint_status_quality
{
    LABEL       [status_quality];
    HELP        [func_ao_setpoint_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_INPUT_NO_RCAS
    }
    POST_EDIT_ACTIONS
    {
        method_set_status_limit_func5_DO_3
    }
    HANDLING    READ & WRITE;
}

func5_DO_3_setpoint_status_limit          LIKE VARIABLE    func5_DO_3_setpoint_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_INPUT_LIMIT (func5_DO_3_setpoint_status_quality)
    }
}

VARIABLE func5_DO_3_out_value
{
    LABEL       [func_out_value];
    HELP        [func_ao_out_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }

    HANDLING
        IF ((func5_DO_3_target_mode == BLOCK_MODE_MAN) || (func5_DO_3_target_mode == BLOCK_MODE_LO))
        {
            READ & WRITE;
        }
        ELSE {
            READ;
        }
}

VARIABLE func5_DO_3_out_status_quality
{
    LABEL       [status_quality];
    HELP        [func_out_status_help];
    CLASS        OUTPUT & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        IF ((func5_DO_3_target_mode == BLOCK_MODE_MAN) || (func5_DO_3_target_mode == BLOCK_MODE_LO))
        {
            STATUS_INPUT_NO_RCAS
        }
        ELSE {
            STATUS_OUTPUT_NO_RCAS
        }
    }
    POST_EDIT_ACTIONS
    {
        IF ((func5_DO_3_target_mode == BLOCK_MODE_MAN) || (func5_DO_3_target_mode == BLOCK_MODE_LO))
        {
            method_set_status_limit_func5_DO_3
        }
    }
    HANDLING
        IF ((func5_DO_3_target_mode == BLOCK_MODE_MAN) || (func5_DO_3_target_mode == BLOCK_MODE_LO))
        {
            READ & WRITE;
        }
        ELSE {
            READ;
        }
}

func5_DO_3_out_status_limit               LIKE VARIABLE    func5_DO_3_out_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func5_DO_3_out_status_quality)
    }
}

VARIABLE func5_DO_3_readback_value
{
    LABEL       [func_do_readback_value];
    HELP        [func_do_readback_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ;
}

VARIABLE func5_DO_3_readback_status_quality
{
    LABEL       [status_quality];
    HELP        [func_do_readback_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_NO_RCAS
    }
    HANDLING    READ;
}

func5_DO_3_readback_status_limit          LIKE VARIABLE    func5_DO_3_readback_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func5_DO_3_rcas_in_value
{
    LABEL       [func_rcas_in_value];
    HELP        [func_rcas_in_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_3_rcas_in_status_quality
{
    LABEL       [status_quality];
    HELP        [func_rcas_in_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_INPUT_RCAS
    }
    POST_EDIT_ACTIONS
    {
        method_set_status_limit_func5_DO_3
    }
    HANDLING    READ & WRITE;
}

func5_DO_3_rcas_in_status_limit           LIKE VARIABLE    func5_DO_3_rcas_in_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func5_DO_3_rcas_in_status_quality)
    }
}

VARIABLE func5_DO_3_in_channel
{
    LABEL       [func_channel];
    HELP        [func_channel_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE   3;
        {1,    "Mod_Out_D_1(TB)"              },
        {2,    "Mod_Out_D_2(TB)"              },
        {3,    "Mod_Out_D_3(TB)"              },
        {4,    "Mod_Out_D_4(TB)"              }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_3_invert
{
    LABEL       [func_invert];
    HELP        [func_invert_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [func_invert_NOT_INVERT]    },
        {    1,    [func_invert_INVERT]        }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_3_fsafe_time
{
    LABEL       [func_ao_fsafe_time];
    HELP        [func_ao_fsafe_time_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE    0.0;
    }
    CONSTANT_UNIT    [sec];
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_3_fsafe_type
{
    LABEL       [func_ao_fsafe_type];
    HELP        [func_ao_fsafe_type_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    2;
        {    0,    [func_ao_fsafe_type_FAIL_SAFE_VALUE]        },
        {    1,    [func_ao_fsafe_type_STORING_LAST_SETPOINT]  },
        {    2,    [func_ao_fsafe_type_FAIL_SAFE_POSITION]     }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_3_fsafe_value
{
    LABEL       [func_do_fsafe_value];
    HELP        [func_do_fsafe_value_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING        READ & WRITE;
}

VARIABLE func5_DO_3_rcas_out_value
{
    LABEL       [func_rcas_out_value];
    HELP        [func_rcas_out_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
}

VARIABLE func5_DO_3_rcas_out_status_quality
{
    LABEL       [status_quality];
    HELP        [func_rcas_out_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_RCAS
    }
    HANDLING    READ;
}

func5_DO_3_rcas_out_status_limit          LIKE VARIABLE    func5_DO_3_rcas_out_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func5_DO_3_simulate_value
{
    LABEL       [func_simulate_value];
    HELP        [func_ao_simulate_value_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_3_simulate_status_quality
{
    LABEL       [status_quality];
    HELP        [func_simulate_status_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_INPUT_NO_RCAS
    }
    POST_EDIT_ACTIONS
    {
        method_set_status_limit_func5_DO_3
    }
    HANDLING    READ & WRITE;
}

func5_DO_3_simulate_status_limit          LIKE VARIABLE    func5_DO_3_simulate_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func5_DO_3_simulate_status_quality)
    }
}

VARIABLE func5_DO_3_simulation_enabled
{
    LABEL       [func_simulation_enabled];
    HELP        [func_simulation_enabled_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        {    0,    [disabled]       },
        {    1,    [enabled]        }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_3_check_back
{
    LABEL       [func_check_back];
    HELP        [func_check_back_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        BIT_ENUMERATED (3)
    {
        {    0,                      [dia_OK],                [dia_OK_help]                },
        {    CB_FAIL_SAFE,           [cb_FAIL_SAFE],          [cb_FAIL_SAFE_help]          },
        {    CB_REQ_LOC_OP,          [cb_REQ_LOC_OP],         [cb_REQ_LOC_OP_help]         },
        {    CB_LOCAL_OP,            [cb_LOCAL_OP],           [cb_LOCAL_OP_help]           },
        {    CB_OVERRIDE,            [cb_OVERRIDE],           [cb_OVERRIDE_help]           },
        {    CB_DISC_DIR,            [cb_DISC_DIR],           [cb_DISC_DIR_help]           },
        {    CB_TORQUE_D_OP,         [cb_TORQUE_D_OP],        [cb_TORQUE_D_OP_help]        },
        {    CB_TORQUE_D_CL,         [cb_TORQUE_D_CL],        [cb_TORQUE_D_CL_help]        },
        {    CB_TRAV_TIME,           [cb_TRAV_TIME],          [cb_TRAV_TIME_help]          },
        {    CB_ACT_OPEN,            [cb_ACT_OPEN],           [cb_ACT_OPEN_help]           },
        {    CB_ACT_CLOSE,           [cb_ACT_CLOSE],          [cb_ACT_CLOSE_help]          },
        {    CB_UPDATE_EVT,          [cb_UPDATE_EVT],         [cb_UPDATE_EVT_help]         },
        {    CB_SIMULATE,            [cb_SIMULATE],           [cb_SIMULATE_help]           },
        {    CB_DISTURBANCE,         [cb_DISTURBANCE],        [cb_DISTURBANCE_help]        },
        {    CB_CONTR_ERR,           [cb_CONTR_ERR],          [cb_CONTR_ERR_help]          },
        {    CB_CONTR_INACT,         [cb_CONTR_INACT],        [cb_CONTR_INACT_help]        },
        {    CB_SELFTEST,            [cb_SELFTEST],           [cb_SELFTEST_help]           },
        {    CB_TOT_VALVE_TRAV,      [cb_TOT_VALVE_TRAV],     [cb_TOT_VALVE_TRAV_help]     },
        {    CB_BREAK_TIME_UNDER,    [cb_BREAK_TIME_UNDER],   [cb_BREAK_TIME_UNDER_help]   },
        {    CB_BREAK_TIME_OVER,     [cb_BREAK_TIME_OVER],    [cb_BREAK_TIME_OVER_help]    },
        {    CB_CYCLE_TEST,          [cb_CYCLE_TEST],         [cb_CYCLE_TEST_help]         },
        {    CB_TRAVEL_TIME_UNDER,   [cb_TRAVEL_TIME_UNDER],  [cb_TRAVEL_TIME_UNDER_help]  },
        {    CB_TRAVEL_TIME_OVER,    [cb_TRAVEL_TIME_OVER],   [cb_TRAVEL_TIME_OVER_help]   }
    }
    HANDLING    READ;
    STYLE      "MULTILINE 10 8" ;
}

VARIABLE func5_DO_3_check_back_mask
{
    LABEL       [func_check_back_mask];
    HELP        [func_check_back_mask_help];
    CLASS       CONTAINED;
    TYPE        BIT_ENUMERATED (3)
    {
        {    CB_FAIL_SAFE,           [cb_FAIL_SAFE],          [cb_FAIL_SAFE_help]          },
        {    CB_REQ_LOC_OP,          [cb_REQ_LOC_OP],         [cb_REQ_LOC_OP_help]         },
        {    CB_LOCAL_OP,            [cb_LOCAL_OP],           [cb_LOCAL_OP_help]           },
        {    CB_OVERRIDE,            [cb_OVERRIDE],           [cb_OVERRIDE_help]           },
        {    CB_DISC_DIR,            [cb_DISC_DIR],           [cb_DISC_DIR_help]           },
        {    CB_TORQUE_D_OP,         [cb_TORQUE_D_OP],        [cb_TORQUE_D_OP_help]        },
        {    CB_TORQUE_D_CL,         [cb_TORQUE_D_CL],        [cb_TORQUE_D_CL_help]        },
        {    CB_TRAV_TIME,           [cb_TRAV_TIME],          [cb_TRAV_TIME_help]          },
        {    CB_ACT_OPEN,            [cb_ACT_OPEN],           [cb_ACT_OPEN_help]           },
        {    CB_ACT_CLOSE,           [cb_ACT_CLOSE],          [cb_ACT_CLOSE_help]          },
        {    CB_UPDATE_EVT,          [cb_UPDATE_EVT],         [cb_UPDATE_EVT_help]         },
        {    CB_SIMULATE,            [cb_SIMULATE],           [cb_SIMULATE_help]           },
        {    CB_DISTURBANCE,         [cb_DISTURBANCE],        [cb_DISTURBANCE_help]        },
        {    CB_CONTR_ERR,           [cb_CONTR_ERR],          [cb_CONTR_ERR_help]          },
        {    CB_CONTR_INACT,         [cb_CONTR_INACT],        [cb_CONTR_INACT_help]        },
        {    CB_SELFTEST,            [cb_SELFTEST],           [cb_SELFTEST_help]           },
        {    CB_TOT_VALVE_TRAV,      [cb_TOT_VALVE_TRAV],     [cb_TOT_VALVE_TRAV_help]     },
        {    CB_BREAK_TIME_UNDER,    [cb_BREAK_TIME_UNDER],   [cb_BREAK_TIME_UNDER_help]   },
        {    CB_BREAK_TIME_OVER,     [cb_BREAK_TIME_OVER],    [cb_BREAK_TIME_OVER_help]    },
        {    CB_CYCLE_TEST,          [cb_CYCLE_TEST],         [cb_CYCLE_TEST_help]         },
        {    CB_TRAVEL_TIME_UNDER,   [cb_TRAVEL_TIME_UNDER],  [cb_TRAVEL_TIME_UNDER_help]  },
        {    CB_TRAVEL_TIME_OVER,    [cb_TRAVEL_TIME_OVER],   [cb_TRAVEL_TIME_OVER_help]   }
    }
    HANDLING    READ;
    STYLE      "MULTILINE 10 8" ;
}

func5_DO_3_out_channel                    LIKE VARIABLE    func5_DO_3_in_channel
{
}

/***********************************************************************/
/*    DO-3 : COMMAND                                                   */
/***********************************************************************/

COMMAND read_func5_DO_3_blk
{
    BLOCK func5_DO_3_block;
    INDEX 0;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_3_blk_reserve,        func5_DO_3_blk_object,
            func5_DO_3_blk_parent_class,   func5_DO_3_blk_class,
            func5_DO_3_blk_dd_reference,   func5_DO_3_blk_dd_rev,
            func5_DO_3_blk_profile,        func5_DO_3_blk_profile_rev,
            func5_DO_3_blk_execution_time, func5_DO_3_blk_num_parameters,
            func5_DO_3_blk_index_view_1,   func5_DO_3_blk_num_view_lists
        }
    }
}

COMMAND read_func5_DO_3_st_rev
{
    BLOCK func5_DO_3_block;
    INDEX 1;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_3_st_rev
        }
    }
}

COMMAND read_func5_DO_3_tag_desc
{
    BLOCK func5_DO_3_block;
    INDEX 2;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_3_tag_desc
        }
    }
}

COMMAND write_func5_DO_3_tag_desc
{
    BLOCK func5_DO_3_block;
    INDEX 2;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_3_tag_desc
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_3_strategy
{
    BLOCK func5_DO_3_block;
    INDEX 3;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_3_strategy
        }
    }
}

COMMAND write_func5_DO_3_strategy
{
    BLOCK func5_DO_3_block;
    INDEX 3;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_3_strategy
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_3_alert_key
{
    BLOCK func5_DO_3_block;
    INDEX 4;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_3_alert_key
        }
    }
}

COMMAND write_func5_DO_3_alert_key
{
    BLOCK func5_DO_3_block;
    INDEX 4;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_3_alert_key
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_3_target_mode
{
    BLOCK func5_DO_3_block;
    INDEX 5;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_3_target_mode
        }
    }
}

COMMAND write_func5_DO_3_target_mode
{
    BLOCK func5_DO_3_block;
    INDEX 5;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_3_target_mode
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_3_mode
{
    BLOCK func5_DO_3_block;
    INDEX 6;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             func5_DO_3_actual_mode, func5_DO_3_permitted_mode, func5_DO_3_normal_mode
        }
    }
}

COMMAND read_func5_DO_3_alarm
{
    BLOCK func5_DO_3_block;
    INDEX 7;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_3_current_state_alarm_sum, func5_DO_3_unacknowledged_state_alarm_sum,
            func5_DO_3_unreported_state_alarm_sum, func5_DO_3_disabled_state_alarm_sum
        }
    }
}

COMMAND read_func5_DO_3_batch_information
{
    BLOCK func5_DO_3_block;
    INDEX 8;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_3_batch_id, func5_DO_3_batch_unit, func5_DO_3_batch_operation, func5_DO_3_batch_phase
        }
    }
}

COMMAND write_func5_DO_3_batch_information
{
    BLOCK func5_DO_3_block;
    INDEX 8;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_3_batch_id, func5_DO_3_batch_unit, func5_DO_3_batch_operation, func5_DO_3_batch_phase
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_3_setpoint
{
    BLOCK func5_DO_3_block;
    INDEX 9;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_3_setpoint_value,
            func5_DO_3_setpoint_status_quality    <0xFC>,
            func5_DO_3_setpoint_status_limit      <0x03>
        }
    }
}

COMMAND write_func5_DO_3_setpoint
{
    BLOCK func5_DO_3_block;
    INDEX 9;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_3_setpoint_value,
            func5_DO_3_setpoint_status_quality    <0xFC>,
            func5_DO_3_setpoint_status_limit      <0x03>
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_3_out
{
    BLOCK func5_DO_3_block;
    INDEX 10;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_3_out_value,
            func5_DO_3_out_status_quality      <0xFC>,
            func5_DO_3_out_status_limit        <0x03>
        }
    }
}

COMMAND write_func5_DO_3_out
{
    BLOCK func5_DO_3_block;
    INDEX 10;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_3_out_value,
            func5_DO_3_out_status_quality      <0xFC>,
            func5_DO_3_out_status_limit        <0x03>
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_3_readback
{
    BLOCK func5_DO_3_block;
    INDEX 12;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_3_readback_value,
            func5_DO_3_readback_status_quality    <0xFC>,
            func5_DO_3_readback_status_limit      <0x03>
        }
    }
}

COMMAND read_func5_DO_3_rcas_in
{
    BLOCK func5_DO_3_block;
    INDEX 14;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_3_rcas_in_value,
            func5_DO_3_rcas_in_status_quality      <0xFC>,
            func5_DO_3_rcas_in_status_limit        <0x03>
        }
    }
}

COMMAND write_func5_DO_3_rcas_in
{
    BLOCK func5_DO_3_block;
    INDEX 14;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_3_rcas_in_value,
            func5_DO_3_rcas_in_status_quality      <0xFC>,
            func5_DO_3_rcas_in_status_limit        <0x03>
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_3_in_channel
{
    BLOCK func5_DO_3_block;
    INDEX 17;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_3_in_channel
        }
    }
}

COMMAND write_func5_DO_3_in_channel
{
    BLOCK func5_DO_3_block;
    INDEX 17;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_3_in_channel
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_3_invert
{
    BLOCK func5_DO_3_block;
    INDEX 18;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_3_invert
        }
    }
}

COMMAND write_func5_DO_3_invert
{
    BLOCK func5_DO_3_block;
    INDEX 18;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_3_invert
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_3_fsafe_time
{
    BLOCK func5_DO_3_block;
    INDEX 19;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_3_fsafe_time
        }
    }
}

COMMAND write_func5_DO_3_fsafe_time
{
    BLOCK func5_DO_3_block;
    INDEX 19;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_3_fsafe_time
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_3_fsafe_type
{
    BLOCK func5_DO_3_block;
    INDEX 20;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_3_fsafe_type
        }
    }
}

COMMAND write_func5_DO_3_fsafe_type
{
    BLOCK func5_DO_3_block;
    INDEX 20;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_3_fsafe_type
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_3_fsafe_value
{
    BLOCK func5_DO_3_block;
    INDEX 21;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_3_fsafe_value
        }
    }
}

COMMAND write_func5_DO_3_fsafe_value
{
    BLOCK func5_DO_3_block;
    INDEX 21;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_3_fsafe_value
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_3_rcas_out_value
{
    BLOCK func5_DO_3_block;
    INDEX 22;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_3_rcas_out_value,
            func5_DO_3_rcas_out_status_quality    <0xFC>,
            func5_DO_3_rcas_out_status_limit      <0x03>

        }
    }
}

COMMAND read_func5_DO_3_simulate
{
    BLOCK func5_DO_3_block;
    INDEX 24;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_3_simulate_status_quality    <0xFC>,
            func5_DO_3_simulate_status_limit      <0x03>,
            func5_DO_3_simulate_value,
            func5_DO_3_simulation_enabled
        }
    }
}

COMMAND write_func5_DO_3_simulate
{
    BLOCK func5_DO_3_block;
    INDEX 24;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_3_simulate_status_quality    <0xFC>,
            func5_DO_3_simulate_status_limit      <0x03>,
            func5_DO_3_simulate_value,
            func5_DO_3_simulation_enabled
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_3_check_back
{
    BLOCK func5_DO_3_block;
    INDEX 33;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_3_check_back
        }
    }
}

COMMAND read_func5_DO_3_check_back_mask
{
    BLOCK func5_DO_3_block;
    INDEX 34;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_3_check_back_mask
        }
    }
}

COMMAND read_func5_DO_3_out_channel
{
    BLOCK func5_DO_3_block;
    INDEX 35;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_3_out_channel
        }
    }
}

COMMAND write_func5_DO_3_out_channel
{
    BLOCK func5_DO_3_block;
    INDEX 35;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_3_out_channel
        }
        REPLY
        {
        }
    }
}

/***********************************************************************/
/*    DO-3 : MENUs                                                     */
/***********************************************************************/

MENU Tab_s_func5_DO_3
{
    LABEL        "DO-3";
    ITEMS
    {
        func5_DO_3_st_rev,
        //func5_DO_3_in_channel,
        func5_DO_3_out_channel,
        func5_DO_3_invert,
        Tab_s_func5_DO_3_batch,
        Tab_s_func5_DO_3_fsafe
    }
}

MENU Tab_m_func5_DO_3
{
    LABEL       [MT_DO_3];
    ITEMS
    {
        func5_DO_3_st_rev,
        //func5_DO_3_in_channel (READ_ONLY),
        func5_DO_3_out_channel (READ_ONLY),
        func5_DO_3_invert      (READ_ONLY),
        Tab_s_func5_DO_3_batch,
        Tab_m_func5_DO_3_fsafe
    }
}

MENU Tab_s_func5_DO_3_batch
{
    LABEL       [menu_ident_batch_info];
    ITEMS
    {
        func5_DO_3_batch_id,
        func5_DO_3_batch_unit,
        func5_DO_3_batch_operation,
        func5_DO_3_batch_phase
    }
}

MENU Tab_s_func5_DO_3_fsafe
{
    LABEL       [menu_fail_safe] ;
    ITEMS
    {
        func5_DO_3_fsafe_type,
        func5_DO_3_fsafe_time,
        func5_DO_3_fsafe_value
    }
}

MENU Tab_m_func5_DO_3_fsafe
{
    LABEL       [menu_fail_safe] ;
    ITEMS
    {
        func5_DO_3_fsafe_type  (READ_ONLY),
        func5_DO_3_fsafe_time  (READ_ONLY),
        func5_DO_3_fsafe_value (READ_ONLY)
    }
}

/*---------------------------------------------------------------------*/
/*    DO-3 : Online-Windows                                            */
/*---------------------------------------------------------------------*/

MENU Page_display_measure_func5_DO_3
{
    LABEL        "DO-3";
    ITEMS
    {
        Group_display_readback_func5_DO_3,
        Group_display_setpoint_func5_DO_3,
        func5_DO_3_check_back,
        Group_display_out_func5_DO_3,
    }
}

MENU Group_display_out_func5_DO_3
{
    LABEL       [func_out_value];
    ITEMS
    {
        func5_DO_3_out_value                (READ_ONLY),
        COLUMNBREAK,
        func5_DO_3_out_status_quality       (READ_ONLY),
        func5_DO_3_out_status_limit         (READ_ONLY)
    }
}

MENU Group_display_readback_func5_DO_3
{
    LABEL       [func_ao_readback_value];
    ITEMS
    {
        func5_DO_3_readback_value,
        COLUMNBREAK,
        func5_DO_3_readback_status_quality,
        func5_DO_3_readback_status_limit
    }
}

MENU Group_display_setpoint_func5_DO_3
{
    LABEL       [func_ao_setpoint_value];
    ITEMS
    {
        func5_DO_3_setpoint_value             (READ_ONLY),
        COLUMNBREAK,
        func5_DO_3_setpoint_status_quality    (READ_ONLY),
        func5_DO_3_setpoint_status_limit      (READ_ONLY)
    }
}

MENU OnlineWindow_S_alarm_func5_DO_3
{
    LABEL        "DO-3";
    ITEMS
    {
        Page_alarm_sum_func5_DO_3,
    }
}

MENU Page_alarm_sum_func5_DO_3
{
    LABEL       [menu_dialog_alarm_sum];
    ITEMS
    {
        func5_DO_3_current_state_alarm_sum,
        func5_DO_3_unreported_state_alarm_sum
    }
}

/*---------------------------------------------------------------------*/
/*    DO-3 : Online-Dialogs                                            */
/*---------------------------------------------------------------------*/

MENU OnlineDialog_operation_func5_DO_3
{
    LABEL        "DO-3";
    ITEMS
    {
        Page_operation_AUTO_func5_DO_3,
        Page_operation_RCAS_func5_DO_3,
        Page_operation_MAN_func5_DO_3,
        Page_simulation_func5_DO_3
    }
}

MENU Page_operation_AUTO_func5_DO_3
{
    LABEL       [mode_AUTO];
    ITEMS
    {
        func5_DO_3_target_mode,
        func5_DO_3_actual_mode,
        Group_setpoint_DO_func5_DO_3,
        Group_readback_func5_DO_3,
        func5_DO_3_check_back,
        method_set
    }
}

MENU Page_operation_RCAS_func5_DO_3
{
    LABEL       [mode_RCAS];
    ITEMS
    {
        func5_DO_3_target_mode,
        func5_DO_3_actual_mode,
        Group_rcas_in_DO_func5_DO_3,
        Group_rcas_out_DO_func5_DO_3,
        Group_readback_func5_DO_3,
        func5_DO_3_check_back,
        method_set
    }
}

MENU Page_operation_MAN_func5_DO_3
{
    LABEL       [mode_MAN];
    ITEMS
    {
        func5_DO_3_target_mode,
        func5_DO_3_actual_mode,
        Group_out_func5_DO_3,
        Group_readback_func5_DO_3,
        func5_DO_3_check_back,
        method_set
    }
}

MENU Page_simulation_func5_DO_3
{
    LABEL       [menu_dialog_simulation];
    ITEMS
    {
        func5_DO_3_simulation_enabled,
        Group_simulation_func5_DO_3,
        func5_DO_3_check_back,
        method_set
    }
}

MENU Group_setpoint_DO_func5_DO_3
{
    LABEL       [func_ao_setpoint_value];
    ITEMS
    {
        func5_DO_3_setpoint_value,
        COLUMNBREAK,
        func5_DO_3_setpoint_status_quality,
        func5_DO_3_setpoint_status_limit
    }
}

MENU Group_readback_func5_DO_3
{
    LABEL       [func_ao_readback_value];
    ITEMS
    {
        func5_DO_3_readback_value,
        COLUMNBREAK,
        func5_DO_3_readback_status_quality,
        func5_DO_3_readback_status_limit
    }
}

MENU Group_rcas_in_DO_func5_DO_3
{
    LABEL       [func_rcas_in_value];
    ITEMS
    {
        func5_DO_3_rcas_in_value,
        COLUMNBREAK,
        func5_DO_3_rcas_in_status_quality,
        func5_DO_3_rcas_in_status_limit
    }
}

MENU Group_rcas_out_DO_func5_DO_3
{
    LABEL       [func_rcas_out_value];
    ITEMS
    {
        func5_DO_3_rcas_out_value,
        COLUMNBREAK,
        func5_DO_3_rcas_out_status_quality,
        func5_DO_3_rcas_out_status_limit
    }
}

MENU Group_out_func5_DO_3
{
    LABEL       [menu_output];
    ITEMS
    {
        func5_DO_3_out_value,
        COLUMNBREAK,
        func5_DO_3_out_status_quality,
        func5_DO_3_out_status_limit
    }
}

MENU Group_simulation_func5_DO_3
{
    LABEL       [menu_dialog_simulation];
    ITEMS
    {
        func5_DO_3_simulate_value,
        COLUMNBREAK,
        func5_DO_3_simulate_status_quality,
        func5_DO_3_simulate_status_limit
    }
}

MENU Page_diagnosis_func5_DO_3
{
    LABEL        "DO-3";
    ITEMS
    {
        func5_DO_3_blk_object,
        func5_DO_3_blk_parent_class,
        func5_DO_3_blk_class,
        func5_DO_3_blk_dd_reference,
        func5_DO_3_blk_dd_rev,
        func5_DO_3_blk_profile,
        func5_DO_3_blk_profile_rev,
        func5_DO_3_st_rev,
        func5_DO_3_actual_mode,
        func5_DO_3_simulation_enabled (READ_ONLY)
    }
}

MENU OnlineDialog_DO_3_setting
{
    LABEL        "DO-3 Block Mode";
    ITEMS
    {
        Page_mode_DO_3
        Page_actuator_DO_3
    }
}

MENU Page_mode_DO_3
{
    LABEL        "Config Block Mode";
    ITEMS
    {
        Group_mode_DO_3,
        Group_output_DO_3,
        Group_setpoint_DO_3,
        Group_rcas_in_DO_3,
        Group_rcas_out_DO_3,
        method_set
    }
}


MENU Group_mode_DO_3
{
    LABEL        "Config Block Mode";
    ITEMS
    {
        func5_DO_3_target_mode,
        COLUMNBREAK,
        func5_DO_3_actual_mode
    }
}

MENU Group_output_DO_3
{
    LABEL        "Set Output (MAN)"; /* [func_out_value]; */
    ITEMS
    {
        func5_DO_3_out_value,
        COLUMNBREAK,
        func5_DO_3_out_status_quality,
        func5_DO_3_out_status_limit
    }
}

MENU Group_setpoint_DO_3
{
    LABEL        "Set Setpoint from Operator - SP (AUTO)"; /* [func_out_value]; */
    ITEMS
    {
        func5_DO_3_setpoint_value,
        COLUMNBREAK,
        func5_DO_3_setpoint_status_quality,
        func5_DO_3_setpoint_status_limit
    }
}

MENU Group_rcas_in_DO_3
{
    LABEL        "Set Setpoint from Remote Station - RCAS_IN (RCAS)"; /* [func_out_value]; */
    ITEMS
    {
        func5_DO_3_rcas_in_value,
        COLUMNBREAK,
        func5_DO_3_rcas_in_status_quality,
        func5_DO_3_rcas_in_status_limit
    }
}

MENU Group_rcas_out_DO_3
{
    LABEL        "From RCAS_OUT to Remote Station"; /* [func_out_value]; */
    ITEMS
    {
        func5_DO_3_rcas_out_value,
        COLUMNBREAK,
        func5_DO_3_rcas_out_status_quality,
        func5_DO_3_rcas_out_status_limit
    }
}

MENU Page_actuator_DO_3
{
    LABEL        "Feedback";
    ITEMS
    {
        Group_readback_DO_3,
        func5_DO_3_check_back,
        func5_DO_3_current_state_alarm_sum
    }
}

MENU Group_readback_DO_3
{
    LABEL        "Readback to Transducer"; /* [func_out_value]; */
    ITEMS
    {
        func5_DO_3_readback_value,
        COLUMNBREAK,
        func5_DO_3_readback_status_quality,
        func5_DO_3_readback_status_limit
    }
}

MENU OnlineDialog_simulation_DO_3
{
    LABEL        "Simulate DO-3"; /* "Simulate AI"; */
    ITEMS
    {
        Page_simulation_DO_3,
        Page_simulation_out_DO_3
    }
}

MENU Page_simulation_DO_3
{
    LABEL        [menu_dialog_simulation_input];
    ITEMS
    {
        func5_DO_3_simulation_enabled,
        Group_simulate_value_DO_3,
        Group_readback_DO_3,
        method_set
    }
}

MENU Group_simulate_value_DO_3
{
    LABEL     "Simulation Value";
    ITEMS
    {
        func5_DO_3_simulate_value,
        COLUMNBREAK,
        func5_DO_3_simulate_status_quality,
        func5_DO_3_simulate_status_limit
    }
}

MENU Page_simulation_out_DO_3
{
    LABEL        [menu_dialog_simulation_output];
    ITEMS
    {
        Group_mode_DO_3,
        Group_output_DO_3,
        method_set
    }
}

/*---------------------------------------------------------------------*/
/*    DO-3 : Offline-Windows                                           */
/*---------------------------------------------------------------------*/

MENU OfflineWindow_DO_3_geral
{
    LABEL "DO-3"; 
    ITEMS
    {
        Page_basic_DO_3,
        Page_advanced_DO_3
    }
}

MENU Page_basic_DO_3
{
    LABEL [MC_Tab_basic];
    ITEMS
    {
        Group_target_mode_DO_3,
        Group_channel_DO_3,
        Group_Set_Invert_DO_3
    }
}

MENU Page_advanced_DO_3
{
    LABEL [MC_Tab_advanced];
    ITEMS
    {
        Group_fault_set_DO_3,
        Group_batch_DO_3
    }
}

MENU Page_batch_DO_3
{
    LABEL [MC_Batch_Info];
    ITEMS
    {
        Group_batch_DO_3
    }
}


MENU Group_target_mode_DO_3
{
    LABEL "Config Block Mode";
    ITEMS
    {
        func5_DO_3_target_mode,
        COLUMNBREAK,
        method_write_target_mode_DO_3
    }
}

MENU Group_channel_DO_3
{
    LABEL        "Select Channel";
    ITEMS
    {
        //func5_DO_3_in_channel,
        func5_DO_3_out_channel,
        COLUMNBREAK,
        method_write_channel_in_out_DO_3
    }
}

MENU Group_channel_out_DO_3
{
    LABEL        "Select Output";
    ITEMS
    {
        func5_DO_3_out_channel,
        COLUMNBREAK,
        method_write_channel_out_DO_3
    }
}

MENU Group_Set_Invert_DO_3
{
    LABEL "Set Invert Input Value";
    ITEMS
    {
        func5_DO_3_invert,
        COLUMNBREAK,
        method_write_invert_DO_3
    }
}

MENU Group_fault_set_DO_3
{
    LABEL     "Set Fail Safe Values";
    ITEMS
    {
        func5_DO_3_fsafe_type,
        func5_DO_3_fsafe_value,
        func5_DO_3_fsafe_time,
        COLUMNBREAK,
        method_write_fail_DO_3
    }
}

MENU Group_batch_DO_3
{
    LABEL        "Define Batch Information";
    ITEMS
    {
        func5_DO_3_batch_id,
        func5_DO_3_batch_unit,
        func5_DO_3_batch_operation,
        func5_DO_3_batch_phase,
        COLUMNBREAK,
        method_write_batch_DO_3
    }
}

/*---------------------------------------------------------------------*/
/*    DO-3 : Methods                                                   */
/*---------------------------------------------------------------------*/

METHOD method_write_target_mode_DO_3
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_3_target_mode);
        ReadCommand(read_func5_DO_3_target_mode);
    }
}

METHOD method_write_channel_in_out_DO_3
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_3_in_channel);
        ReadCommand(read_func5_DO_3_in_channel);
        iassign(func5_DO_3_out_channel, func5_DO_3_in_channel);
        WriteCommand(write_func5_DO_3_out_channel);
        ReadCommand(read_func5_DO_3_out_channel);
    }
}

METHOD method_write_channel_out_DO_3
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_3_out_channel);
        ReadCommand(read_func5_DO_3_out_channel);
    }
}

METHOD method_write_invert_DO_3
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_3_invert);
        ReadCommand(read_func5_DO_3_invert);
    }
}

METHOD method_write_scale_in_DO_3
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_3_pv);
        ReadCommand(read_func5_DO_3_pv);
    }
}

METHOD method_write_scale_out_DO_3
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_3_out_scale);
        ReadCommand(read_func5_DO_3_out_scale);
    }
}

METHOD method_write_fail_DO_3
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_3_fsafe_type);
        WriteCommand(write_func5_DO_3_fsafe_time);
        WriteCommand(write_func5_DO_3_fsafe_value);
        ReadCommand(read_func5_DO_3_fsafe_type);
        ReadCommand(read_func5_DO_3_fsafe_time);
        ReadCommand(read_func5_DO_3_fsafe_value);
    }
}

METHOD method_write_batch_DO_3
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_3_batch_information);
    }
}

METHOD method_set_status_limit_func5_DO_3
{
    CLASS        INPUT;
    LABEL       "set status limit";
    DEFINITION
    {
        int    quality;
        int block_mode;

        quality = ivar_value(func5_DO_3_setpoint_status_quality);
        if ((quality == 0x20) || (quality == 0x30))
            iassign(func5_DO_3_setpoint_status_limit, 0);

        quality = ivar_value(func5_DO_3_rcas_in_status_quality);
        if ((quality == 0x20) || (quality == 0x30))
            iassign(func5_DO_3_rcas_in_status_limit, 0);

        quality = ivar_value(func5_DO_3_simulate_status_quality);
        if ((quality == 0x20) || (quality == 0x30))
            iassign(func5_DO_3_simulate_status_limit, 0);

        block_mode    = ivar_value(func5_DO_3_target_mode);
        quality        = ivar_value(func5_DO_3_out_status_quality);
        if (((block_mode == BLOCK_MODE_MAN) || (block_mode == BLOCK_MODE_LO)) && ((quality == 0x20) || (quality == 0x30)))
            iassign(func5_DO_3_out_status_limit, 0);
    }
}

/***********************************************************************/
/*    DO Function Block 4                                              */
/***********************************************************************/

BLOCK func5_DO_4_block
{
    TYPE    FUNCTION;
    NUMBER    16;
}

func5_DO_4_blk_reserve                      LIKE VARIABLE    phys_blk_reserve
{
}

VARIABLE func5_DO_4_blk_object
{
    LABEL       [blk_block_object];
    HELP        [blk_block_object_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    2,    [blk_block_object_FUNCTION]        }
    }
    HANDLING    READ;
}

VARIABLE func5_DO_4_blk_parent_class
{
    LABEL       [blk_parent_class];
    HELP        [func_blk_parent_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    2,    [func_blk_parent_class_OUTPUT]    }
    }
    HANDLING    READ;
}

VARIABLE func5_DO_4_blk_class
{
    LABEL       [blk_class];
    HELP        [func_blk_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    2,      [func_blk_class_DO]      },
        {    250,    [not_used]               },
        {    251,    [none]                   },
        {    252,    [unknown]                },
        {    253,    [special]                }
    }
    HANDLING    READ;
}

func5_DO_4_blk_dd_reference                 LIKE VARIABLE    phys_blk_dd_reference
{
}

func5_DO_4_blk_dd_rev                       LIKE VARIABLE    phys_blk_dd_rev
{
}

func5_DO_4_blk_profile                      LIKE VARIABLE    phys_blk_profile
{
}

func5_DO_4_blk_profile_rev                  LIKE VARIABLE    phys_blk_profile_rev
{
}

func5_DO_4_blk_execution_time               LIKE VARIABLE    phys_blk_execution_time
{
}

func5_DO_4_blk_num_parameters               LIKE VARIABLE    phys_blk_num_parameters
{
}

func5_DO_4_blk_index_view_1                 LIKE VARIABLE    phys_blk_index_view_1
{
}

func5_DO_4_blk_num_view_lists               LIKE VARIABLE    phys_blk_num_view_lists
{
}

func5_DO_4_st_rev                           LIKE VARIABLE    phys_st_rev
{
}

func5_DO_4_tag_desc                         LIKE VARIABLE    phys_tag_desc
{
    REDEFINE LABEL        [MC_DO_4_tag_desc];
    TYPE                  ASCII (32)
    {
        REDEFINE DEFAULT_VALUE  "";
    }
}

func5_DO_4_strategy                         LIKE VARIABLE    phys_strategy
{
}

func5_DO_4_alert_key                        LIKE VARIABLE    phys_alert_key
{
}

VARIABLE func5_DO_4_target_mode
{
    LABEL       [target_mode];
    HELP        [target_mode_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x02,    [mode_RCAS]              },
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x20,    [mode_LO]                },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_4_actual_mode
{
    LABEL       [actual_mode];
    HELP        [actual_mode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x02,    [mode_RCAS]              },
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x20,    [mode_LO]                },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE func5_DO_4_permitted_mode
{
    LABEL       [permitted_mode];
    HELP        [permitted_mode_help];
    CLASS       CONTAINED;
    TYPE        BIT_ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x02,    [mode_RCAS]              },
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x20,    [mode_LO]                },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE func5_DO_4_normal_mode
{
    LABEL       [normal_mode];
    HELP        [normal_mode_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x02,    [mode_RCAS]              },
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x20,    [mode_LO]                },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

func5_DO_4_current_state_alarm_sum          LIKE VARIABLE    phys_current_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func5_DO_4_unacknowledged_state_alarm_sum   LIKE VARIABLE    phys_unacknowledged_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func5_DO_4_unreported_state_alarm_sum       LIKE VARIABLE    phys_unreported_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func5_DO_4_disabled_state_alarm_sum         LIKE VARIABLE    phys_disabled_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

VARIABLE func5_DO_4_batch_id
{
    LABEL       [func_batch_id];
    HELP        [func_batch_id_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (4)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_4_batch_unit
{
    LABEL       [func_batch_unit];
    HELP        [func_batch_unit_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_4_batch_operation
{
    LABEL       [func_batch_operation];
    HELP        [func_batch_operation_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_4_batch_phase
{
    LABEL       [func_batch_phase];
    HELP        [func_batch_phase_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

/*---------------------------------------------------------------------*/
/*    DO-4 : Additional Parameter                                      */
/*---------------------------------------------------------------------*/

VARIABLE func5_DO_4_setpoint_value
{
    LABEL       [func_ao_setpoint_value];
    HELP        [func_ao_setpoint_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_4_setpoint_status_quality
{
    LABEL       [status_quality];
    HELP        [func_ao_setpoint_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_INPUT_NO_RCAS
    }
    POST_EDIT_ACTIONS
    {
        method_set_status_limit_func5_DO_4
    }
    HANDLING    READ & WRITE;
}

func5_DO_4_setpoint_status_limit            LIKE VARIABLE    func5_DO_4_setpoint_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_INPUT_LIMIT (func5_DO_4_setpoint_status_quality)
    }
}

VARIABLE func5_DO_4_out_value
{
    LABEL       [func_out_value];
    HELP        [func_ao_out_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING
        IF ((func5_DO_4_target_mode == BLOCK_MODE_MAN) || (func5_DO_4_target_mode == BLOCK_MODE_LO))
        {
            READ & WRITE;
        }
        ELSE {
            READ;
        }
}

VARIABLE func5_DO_4_out_status_quality
{
    LABEL       [status_quality];
    HELP        [func_out_status_help];
    CLASS        OUTPUT & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        IF ((func5_DO_4_target_mode == BLOCK_MODE_MAN) || (func5_DO_4_target_mode == BLOCK_MODE_LO))
        {
            STATUS_INPUT_NO_RCAS
        }
        ELSE {
            STATUS_OUTPUT_NO_RCAS
        }
    }
    POST_EDIT_ACTIONS
    {
        IF ((func5_DO_4_target_mode == BLOCK_MODE_MAN) || (func5_DO_4_target_mode == BLOCK_MODE_LO))
        {
            method_set_status_limit_func5_DO_4
        }
    }
    HANDLING
        IF ((func5_DO_4_target_mode == BLOCK_MODE_MAN) || (func5_DO_4_target_mode == BLOCK_MODE_LO))
        {
            READ & WRITE;
        }
        ELSE {
            READ;
        }
}

func5_DO_4_out_status_limit                 LIKE VARIABLE    func5_DO_4_out_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func5_DO_4_out_status_quality)
    }
}

VARIABLE func5_DO_4_readback_value
{
    LABEL       [func_do_readback_value];
    HELP        [func_do_readback_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ;
}

VARIABLE func5_DO_4_readback_status_quality
{
    LABEL       [status_quality];
    HELP        [func_do_readback_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_NO_RCAS
    }
    HANDLING    READ;
}

func5_DO_4_readback_status_limit            LIKE VARIABLE    func5_DO_4_readback_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func5_DO_4_rcas_in_value
{
    LABEL       [func_rcas_in_value];
    HELP        [func_rcas_in_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_4_rcas_in_status_quality
{
    LABEL       [status_quality];
    HELP        [func_rcas_in_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_INPUT_RCAS
    }
    POST_EDIT_ACTIONS
    {
        method_set_status_limit_func5_DO_4
    }
    HANDLING    READ & WRITE;
}

func5_DO_4_rcas_in_status_limit             LIKE VARIABLE    func5_DO_4_rcas_in_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func5_DO_4_rcas_in_status_quality)
    }
}

VARIABLE func5_DO_4_in_channel
{
    LABEL       [func_channel];
    HELP        [func_channel_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE   4;
        {1,    "Mod_Out_D_1(TB)"              },
        {2,    "Mod_Out_D_2(TB)"              },
        {3,    "Mod_Out_D_3(TB)"              },
        {4,    "Mod_Out_D_4(TB)"              }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_4_invert
{
    LABEL       [func_invert];
    HELP        [func_invert_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [func_invert_NOT_INVERT]    },
        {    1,    [func_invert_INVERT]        }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_4_fsafe_time
{
    LABEL       [func_ao_fsafe_time];
    HELP        [func_ao_fsafe_time_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE    0.0;
    }
    CONSTANT_UNIT    [sec];
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_4_fsafe_type
{
    LABEL       [func_ao_fsafe_type];
    HELP        [func_ao_fsafe_type_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    2;
        {    0,    [func_ao_fsafe_type_FAIL_SAFE_VALUE]        },
        {    1,    [func_ao_fsafe_type_STORING_LAST_SETPOINT]  },
        {    2,    [func_ao_fsafe_type_FAIL_SAFE_POSITION]     }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_4_fsafe_value
{
    LABEL       [func_do_fsafe_value];
    HELP        [func_do_fsafe_value_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING        READ & WRITE;
}

VARIABLE func5_DO_4_rcas_out_value
{
    LABEL       [func_rcas_out_value];
    HELP        [func_rcas_out_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
}

VARIABLE func5_DO_4_rcas_out_status_quality
{
    LABEL       [status_quality];
    HELP        [func_rcas_out_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_RCAS
    }
    HANDLING    READ;
}

func5_DO_4_rcas_out_status_limit            LIKE VARIABLE    func5_DO_4_rcas_out_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func5_DO_4_simulate_value
{
    LABEL       [func_simulate_value];
    HELP        [func_ao_simulate_value_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }   
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_4_simulate_status_quality
{
    LABEL       [status_quality];
    HELP        [func_simulate_status_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_INPUT_NO_RCAS
    }
    POST_EDIT_ACTIONS
    {
        method_set_status_limit_func5_DO_4
    }
    HANDLING    READ & WRITE;
}

func5_DO_4_simulate_status_limit            LIKE VARIABLE    func5_DO_4_simulate_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func5_DO_4_simulate_status_quality)
    }
}

VARIABLE func5_DO_4_simulation_enabled
{
    LABEL       [func_simulation_enabled];
    HELP        [func_simulation_enabled_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        {    0,    [disabled]        },
        {    1,    [enabled]        }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func5_DO_4_check_back
{
    LABEL       [func_check_back];
    HELP        [func_check_back_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        BIT_ENUMERATED (3)
    {
        {    0,                      [dia_OK],                [dia_OK_help]                },
        {    CB_FAIL_SAFE,           [cb_FAIL_SAFE],          [cb_FAIL_SAFE_help]          },
        {    CB_REQ_LOC_OP,          [cb_REQ_LOC_OP],         [cb_REQ_LOC_OP_help]         },
        {    CB_LOCAL_OP,            [cb_LOCAL_OP],           [cb_LOCAL_OP_help]           },
        {    CB_OVERRIDE,            [cb_OVERRIDE],           [cb_OVERRIDE_help]           },
        {    CB_DISC_DIR,            [cb_DISC_DIR],           [cb_DISC_DIR_help]           },
        {    CB_TORQUE_D_OP,         [cb_TORQUE_D_OP],        [cb_TORQUE_D_OP_help]        },
        {    CB_TORQUE_D_CL,         [cb_TORQUE_D_CL],        [cb_TORQUE_D_CL_help]        },
        {    CB_TRAV_TIME,           [cb_TRAV_TIME],          [cb_TRAV_TIME_help]          },
        {    CB_ACT_OPEN,            [cb_ACT_OPEN],           [cb_ACT_OPEN_help]           },
        {    CB_ACT_CLOSE,           [cb_ACT_CLOSE],          [cb_ACT_CLOSE_help]          },
        {    CB_UPDATE_EVT,          [cb_UPDATE_EVT],         [cb_UPDATE_EVT_help]         },
        {    CB_SIMULATE,            [cb_SIMULATE],           [cb_SIMULATE_help]           },
        {    CB_DISTURBANCE,         [cb_DISTURBANCE],        [cb_DISTURBANCE_help]        },
        {    CB_CONTR_ERR,           [cb_CONTR_ERR],          [cb_CONTR_ERR_help]          },
        {    CB_CONTR_INACT,         [cb_CONTR_INACT],        [cb_CONTR_INACT_help]        },
        {    CB_SELFTEST,            [cb_SELFTEST],           [cb_SELFTEST_help]           },
        {    CB_TOT_VALVE_TRAV,      [cb_TOT_VALVE_TRAV],     [cb_TOT_VALVE_TRAV_help]     },
        {    CB_BREAK_TIME_UNDER,    [cb_BREAK_TIME_UNDER],   [cb_BREAK_TIME_UNDER_help]   },
        {    CB_BREAK_TIME_OVER,     [cb_BREAK_TIME_OVER],    [cb_BREAK_TIME_OVER_help]    },
        {    CB_CYCLE_TEST,          [cb_CYCLE_TEST],         [cb_CYCLE_TEST_help]         },
        {    CB_TRAVEL_TIME_UNDER,   [cb_TRAVEL_TIME_UNDER],  [cb_TRAVEL_TIME_UNDER_help]  },
        {    CB_TRAVEL_TIME_OVER,    [cb_TRAVEL_TIME_OVER],   [cb_TRAVEL_TIME_OVER_help]   }
    }
    HANDLING    READ;
    STYLE      "MULTILINE 10 8" ;
}

VARIABLE func5_DO_4_check_back_mask
{
    LABEL       [func_check_back_mask];
    HELP        [func_check_back_mask_help];
    CLASS       CONTAINED;
    TYPE        BIT_ENUMERATED (3)
    {
        {    CB_FAIL_SAFE,           [cb_FAIL_SAFE],          [cb_FAIL_SAFE_help]          },
        {    CB_REQ_LOC_OP,          [cb_REQ_LOC_OP],         [cb_REQ_LOC_OP_help]         },
        {    CB_LOCAL_OP,            [cb_LOCAL_OP],           [cb_LOCAL_OP_help]           },
        {    CB_OVERRIDE,            [cb_OVERRIDE],           [cb_OVERRIDE_help]           },
        {    CB_DISC_DIR,            [cb_DISC_DIR],           [cb_DISC_DIR_help]           },
        {    CB_TORQUE_D_OP,         [cb_TORQUE_D_OP],        [cb_TORQUE_D_OP_help]        },
        {    CB_TORQUE_D_CL,         [cb_TORQUE_D_CL],        [cb_TORQUE_D_CL_help]        },
        {    CB_TRAV_TIME,           [cb_TRAV_TIME],          [cb_TRAV_TIME_help]          },
        {    CB_ACT_OPEN,            [cb_ACT_OPEN],           [cb_ACT_OPEN_help]           },
        {    CB_ACT_CLOSE,           [cb_ACT_CLOSE],          [cb_ACT_CLOSE_help]          },
        {    CB_UPDATE_EVT,          [cb_UPDATE_EVT],         [cb_UPDATE_EVT_help]         },
        {    CB_SIMULATE,            [cb_SIMULATE],           [cb_SIMULATE_help]           },
        {    CB_DISTURBANCE,         [cb_DISTURBANCE],        [cb_DISTURBANCE_help]        },
        {    CB_CONTR_ERR,           [cb_CONTR_ERR],          [cb_CONTR_ERR_help]          },
        {    CB_CONTR_INACT,         [cb_CONTR_INACT],        [cb_CONTR_INACT_help]        },
        {    CB_SELFTEST,            [cb_SELFTEST],           [cb_SELFTEST_help]           },
        {    CB_TOT_VALVE_TRAV,      [cb_TOT_VALVE_TRAV],     [cb_TOT_VALVE_TRAV_help]     },
        {    CB_BREAK_TIME_UNDER,    [cb_BREAK_TIME_UNDER],   [cb_BREAK_TIME_UNDER_help]   },
        {    CB_BREAK_TIME_OVER,     [cb_BREAK_TIME_OVER],    [cb_BREAK_TIME_OVER_help]    },
        {    CB_CYCLE_TEST,          [cb_CYCLE_TEST],         [cb_CYCLE_TEST_help]         },
        {    CB_TRAVEL_TIME_UNDER,   [cb_TRAVEL_TIME_UNDER],  [cb_TRAVEL_TIME_UNDER_help]  },
        {    CB_TRAVEL_TIME_OVER,    [cb_TRAVEL_TIME_OVER],   [cb_TRAVEL_TIME_OVER_help]   }
    }
    HANDLING    READ;
    STYLE      "MULTILINE 10 8" ;
}

func5_DO_4_out_channel                      LIKE VARIABLE    func5_DO_4_in_channel
{
}

/***********************************************************************/
/*    DO-4 : COMMAND                                                   */
/***********************************************************************/

COMMAND read_func5_DO_4_blk
{
    BLOCK func5_DO_4_block;
    INDEX 0;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_4_blk_reserve,        func5_DO_4_blk_object,
            func5_DO_4_blk_parent_class,   func5_DO_4_blk_class,
            func5_DO_4_blk_dd_reference,   func5_DO_4_blk_dd_rev,
            func5_DO_4_blk_profile,        func5_DO_4_blk_profile_rev,
            func5_DO_4_blk_execution_time, func5_DO_4_blk_num_parameters,
            func5_DO_4_blk_index_view_1,   func5_DO_4_blk_num_view_lists
        }
    }
}

COMMAND read_func5_DO_4_st_rev
{
    BLOCK func5_DO_4_block;
    INDEX 1;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_4_st_rev
        }
    }
}

COMMAND read_func5_DO_4_tag_desc
{
    BLOCK func5_DO_4_block;
    INDEX 2;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_4_tag_desc
        }
    }
}

COMMAND write_func5_DO_4_tag_desc
{
    BLOCK func5_DO_4_block;
    INDEX 2;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_4_tag_desc
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_4_strategy
{
    BLOCK func5_DO_4_block;
    INDEX 3;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_4_strategy
        }
    }
}

COMMAND write_func5_DO_4_strategy
{
    BLOCK func5_DO_4_block;
    INDEX 3;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_4_strategy
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_4_alert_key
{
    BLOCK func5_DO_4_block;
    INDEX 4;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_4_alert_key
        }
    }
}

COMMAND write_func5_DO_4_alert_key
{
    BLOCK func5_DO_4_block;
    INDEX 4;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_4_alert_key
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_4_target_mode
{
    BLOCK func5_DO_4_block;
    INDEX 5;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_4_target_mode
        }
    }
}

COMMAND write_func5_DO_4_target_mode
{
    BLOCK func5_DO_4_block;
    INDEX 5;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_4_target_mode
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_4_mode
{
    BLOCK func5_DO_4_block;
    INDEX 6;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             func5_DO_4_actual_mode, func5_DO_4_permitted_mode, func5_DO_4_normal_mode
        }
    }
}

COMMAND read_func5_DO_4_alarm
{
    BLOCK func5_DO_4_block;
    INDEX 7;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_4_current_state_alarm_sum, func5_DO_4_unacknowledged_state_alarm_sum,
            func5_DO_4_unreported_state_alarm_sum, func5_DO_4_disabled_state_alarm_sum
        }
    }
}

COMMAND read_func5_DO_4_batch_information
{
    BLOCK func5_DO_4_block;
    INDEX 8;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_4_batch_id, func5_DO_4_batch_unit, func5_DO_4_batch_operation, func5_DO_4_batch_phase
        }
    }
}

COMMAND write_func5_DO_4_batch_information
{
    BLOCK func5_DO_4_block;
    INDEX 8;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_4_batch_id, func5_DO_4_batch_unit, func5_DO_4_batch_operation, func5_DO_4_batch_phase
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_4_setpoint
{
    BLOCK func5_DO_4_block;
    INDEX 9;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_4_setpoint_value,
            func5_DO_4_setpoint_status_quality    <0xFC>,
            func5_DO_4_setpoint_status_limit      <0x03>
        }
    }
}

COMMAND write_func5_DO_4_setpoint
{
    BLOCK func5_DO_4_block;
    INDEX 9;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_4_setpoint_value,
            func5_DO_4_setpoint_status_quality    <0xFC>,
            func5_DO_4_setpoint_status_limit      <0x03>
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_4_out
{
    BLOCK func5_DO_4_block;
    INDEX 10;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_4_out_value,
            func5_DO_4_out_status_quality      <0xFC>,
            func5_DO_4_out_status_limit        <0x03>
        }
    }
}

COMMAND write_func5_DO_4_out
{
    BLOCK func5_DO_4_block;
    INDEX 10;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_4_out_value,
            func5_DO_4_out_status_quality      <0xFC>,
            func5_DO_4_out_status_limit        <0x03>
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_4_readback
{
    BLOCK func5_DO_4_block;
    INDEX 12;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_4_readback_value,
            func5_DO_4_readback_status_quality    <0xFC>,
            func5_DO_4_readback_status_limit      <0x03>
        }
    }
}

COMMAND read_func5_DO_4_rcas_in
{
    BLOCK func5_DO_4_block;
    INDEX 14;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_4_rcas_in_value,
            func5_DO_4_rcas_in_status_quality      <0xFC>,
            func5_DO_4_rcas_in_status_limit        <0x03>
        }
    }
}

COMMAND write_func5_DO_4_rcas_in
{
    BLOCK func5_DO_4_block;
    INDEX 14;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_4_rcas_in_value,
            func5_DO_4_rcas_in_status_quality      <0xFC>,
            func5_DO_4_rcas_in_status_limit        <0x03>
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_4_in_channel
{
    BLOCK func5_DO_4_block;
    INDEX 17;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_4_in_channel
        }
    }
}

COMMAND write_func5_DO_4_in_channel
{
    BLOCK func5_DO_4_block;
    INDEX 17;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_4_in_channel
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_4_invert
{
    BLOCK func5_DO_4_block;
    INDEX 18;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_4_invert
        }
    }
}

COMMAND write_func5_DO_4_invert
{
    BLOCK func5_DO_4_block;
    INDEX 18;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_4_invert
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_4_fsafe_time
{
    BLOCK func5_DO_4_block;
    INDEX 19;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_4_fsafe_time
        }
    }
}

COMMAND write_func5_DO_4_fsafe_time
{
    BLOCK func5_DO_4_block;
    INDEX 19;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_4_fsafe_time
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_4_fsafe_type
{
    BLOCK func5_DO_4_block;
    INDEX 20;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_4_fsafe_type
        }
    }
}

COMMAND write_func5_DO_4_fsafe_type
{
    BLOCK func5_DO_4_block;
    INDEX 20;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_4_fsafe_type
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_4_fsafe_value
{
    BLOCK func5_DO_4_block;
    INDEX 21;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_4_fsafe_value
        }
    }
}

COMMAND write_func5_DO_4_fsafe_value
{
    BLOCK func5_DO_4_block;
    INDEX 21;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_4_fsafe_value
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_4_rcas_out_value
{
    BLOCK func5_DO_4_block;
    INDEX 22;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_4_rcas_out_value,
            func5_DO_4_rcas_out_status_quality    <0xFC>,
            func5_DO_4_rcas_out_status_limit      <0x03>

        }
    }
}

COMMAND read_func5_DO_4_simulate
{
    BLOCK func5_DO_4_block;
    INDEX 24;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_4_simulate_status_quality    <0xFC>,
            func5_DO_4_simulate_status_limit      <0x03>,
            func5_DO_4_simulate_value,
            func5_DO_4_simulation_enabled
        }
    }
}

COMMAND write_func5_DO_4_simulate
{
    BLOCK func5_DO_4_block;
    INDEX 24;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_4_simulate_status_quality    <0xFC>,
            func5_DO_4_simulate_status_limit      <0x03>,
            func5_DO_4_simulate_value,
            func5_DO_4_simulation_enabled
        }
        REPLY
        {
        }
    }
}

COMMAND read_func5_DO_4_check_back
{
    BLOCK func5_DO_4_block;
    INDEX 33;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_4_check_back
        }
    }
}

COMMAND read_func5_DO_4_check_back_mask
{
    BLOCK func5_DO_4_block;
    INDEX 34;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_4_check_back_mask
        }
    }
}

COMMAND read_func5_DO_4_out_channel
{
    BLOCK func5_DO_4_block;
    INDEX 35;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_DO_4_out_channel
        }
    }
}

COMMAND write_func5_DO_4_out_channel
{
    BLOCK func5_DO_4_block;
    INDEX 35;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_DO_4_out_channel
        }
        REPLY
        {
        }
    }
}

/***********************************************************************/
/*    DO-4 : MENUs                                                     */
/***********************************************************************/

MENU Tab_s_func5_DO_4
{
    LABEL        "DO-4";
    ITEMS
    {
        func5_DO_4_st_rev,
        //func5_DO_4_in_channel,
        func5_DO_4_out_channel,
        func5_DO_4_invert,
        Tab_s_func5_DO_4_batch,
        Tab_s_func5_DO_4_fsafe
    }
}

MENU Tab_m_func5_DO_4
{
    LABEL       [MT_DO_4];
    ITEMS
    {
        func5_DO_4_st_rev,
        //func5_DO_4_in_channel (READ_ONLY),
        func5_DO_4_out_channel (READ_ONLY),
        func5_DO_4_invert      (READ_ONLY),
        Tab_s_func5_DO_4_batch,
        Tab_m_func5_DO_4_fsafe
    }
}

MENU Tab_s_func5_DO_4_batch
{
    LABEL       [menu_ident_batch_info];
    ITEMS
    {
        func5_DO_4_batch_id,
        func5_DO_4_batch_unit,
        func5_DO_4_batch_operation,
        func5_DO_4_batch_phase
    }
}

MENU Tab_s_func5_DO_4_fsafe
{
    LABEL       [menu_fail_safe] ;
    ITEMS
    {
        func5_DO_4_fsafe_type,
        func5_DO_4_fsafe_time,
        func5_DO_4_fsafe_value
    }
}

MENU Tab_m_func5_DO_4_fsafe
{
    LABEL       [menu_fail_safe] ;
    ITEMS
    {
        func5_DO_4_fsafe_type  (READ_ONLY),
        func5_DO_4_fsafe_time  (READ_ONLY),
        func5_DO_4_fsafe_value (READ_ONLY)
    }
}

/*---------------------------------------------------------------------*/
/*    DO-4 : Online-Windows                                            */
/*---------------------------------------------------------------------*/

MENU Page_display_measure_func5_DO_4
{
    LABEL        "DO-4";
    ITEMS
    {
        Group_display_readback_func5_DO_4,
        Group_display_setpoint_func5_DO_4,
        func5_DO_4_check_back,
        Group_display_out_func5_DO_4
    }
}

MENU Group_display_out_func5_DO_4
{
    LABEL       [func_out_value];
    ITEMS
    {
        func5_DO_4_out_value               (READ_ONLY),
        COLUMNBREAK,
        func5_DO_4_out_status_quality      (READ_ONLY),
        func5_DO_4_out_status_limit        (READ_ONLY)
    }
}

MENU Group_display_readback_func5_DO_4
{
    LABEL       [func_ao_readback_value];
    ITEMS
    {
        func5_DO_4_readback_value,
        COLUMNBREAK,
        func5_DO_4_readback_status_quality,
        func5_DO_4_readback_status_limit
    }
}

MENU Group_display_setpoint_func5_DO_4
{
    LABEL       [func_ao_setpoint_value];
    ITEMS
    {
        func5_DO_4_setpoint_value             (READ_ONLY),
        COLUMNBREAK,
        func5_DO_4_setpoint_status_quality    (READ_ONLY),
        func5_DO_4_setpoint_status_limit      (READ_ONLY)
    }
}

MENU OnlineWindow_S_alarm_func5_DO_4
{
    LABEL        "DO-4";
    ITEMS
    {
        Page_alarm_sum_func5_DO_4
    }
}

MENU Page_alarm_sum_func5_DO_4
{
    LABEL       [menu_dialog_alarm_sum];
    ITEMS
    {
        func5_DO_4_current_state_alarm_sum,
        func5_DO_4_unreported_state_alarm_sum
    }
}

/*---------------------------------------------------------------------*/
/*    DO-4 : Online-Dialogs                                            */
/*---------------------------------------------------------------------*/

MENU OnlineDialog_operation_func5_DO_4
{
    LABEL        "DO-4";
    ITEMS
    {
        Page_operation_AUTO_func5_DO_4,
        Page_operation_RCAS_func5_DO_4,
        Page_operation_MAN_func5_DO_4,
        Page_simulation_func5_DO_4
    }
}

MENU Page_operation_AUTO_func5_DO_4
{
    LABEL       [mode_AUTO];
    ITEMS
    {
        func5_DO_4_target_mode,
        func5_DO_4_actual_mode,
        Group_setpoint_DO_func5_DO_4,
        Group_readback_func5_DO_4,
        func5_DO_4_check_back,
        method_set
    }
}

MENU Page_operation_RCAS_func5_DO_4
{
    LABEL       [mode_RCAS];
    ITEMS
    {
        func5_DO_4_target_mode,
        func5_DO_4_actual_mode,
        Group_rcas_in_DO_func5_DO_4,
        Group_rcas_out_DO_func5_DO_4,
        Group_readback_func5_DO_4,
        func5_DO_4_check_back,
        method_set
    }
}

MENU Page_operation_MAN_func5_DO_4
{
    LABEL       [mode_MAN];
    ITEMS
    {
        func5_DO_4_target_mode,
        func5_DO_4_actual_mode,
        Group_out_func5_DO_4,
        Group_readback_func5_DO_4,
        func5_DO_4_check_back,
        method_set
    }
}

MENU Page_simulation_func5_DO_4
{
    LABEL       [menu_dialog_simulation];
    ITEMS
    {
        func5_DO_4_simulation_enabled,
        Group_simulation_func5_DO_4,
        func5_DO_4_check_back,
        method_set
    }
}

MENU Group_setpoint_DO_func5_DO_4
{
    LABEL       [func_ao_setpoint_value];
    ITEMS
    {
        func5_DO_4_setpoint_value,
        COLUMNBREAK,
        func5_DO_4_setpoint_status_quality,
        func5_DO_4_setpoint_status_limit
    }
}

MENU Group_readback_func5_DO_4
{
    LABEL       [func_ao_readback_value];
    ITEMS
    {
        func5_DO_4_readback_value,
        COLUMNBREAK,
        func5_DO_4_readback_status_quality,
        func5_DO_4_readback_status_limit
    }
}

MENU Group_rcas_in_DO_func5_DO_4
{
    LABEL       [func_rcas_in_value];
    ITEMS
    {
        func5_DO_4_rcas_in_value,
        COLUMNBREAK,
        func5_DO_4_rcas_in_status_quality,
        func5_DO_4_rcas_in_status_limit
    }
}

MENU Group_rcas_out_DO_func5_DO_4
{
    LABEL       [func_rcas_out_value];
    ITEMS
    {
        func5_DO_4_rcas_out_value,
        COLUMNBREAK,
        func5_DO_4_rcas_out_status_quality,
        func5_DO_4_rcas_out_status_limit
    }
}

MENU Group_out_func5_DO_4
{
    LABEL       [menu_output];
    ITEMS
    {
        func5_DO_4_out_value,
        COLUMNBREAK,
        func5_DO_4_out_status_quality,
        func5_DO_4_out_status_limit
    }
}

MENU Group_simulation_func5_DO_4
{
    LABEL       [menu_dialog_simulation];
    ITEMS
    {
        func5_DO_4_simulate_value,
        COLUMNBREAK,
        func5_DO_4_simulate_status_quality,
        func5_DO_4_simulate_status_limit
    }
}


MENU Page_diagnosis_func5_DO_4
{
    LABEL        "DO-4";
    ITEMS
    {
        func5_DO_4_blk_object,
        func5_DO_4_blk_parent_class,
        func5_DO_4_blk_class,
        func5_DO_4_blk_dd_reference,
        func5_DO_4_blk_dd_rev,
        func5_DO_4_blk_profile,
        func5_DO_4_blk_profile_rev,
        func5_DO_4_st_rev,
        func5_DO_4_actual_mode,
        func5_DO_4_simulation_enabled (READ_ONLY)
    }
}

MENU OnlineDialog_DO_4_setting
{
    LABEL        "DO-4 Block Mode";
    ITEMS
    {
        Page_mode_DO_4
        Page_actuator_DO_4
    }
}

MENU Page_mode_DO_4
{
    LABEL        "Config Block Mode";
    ITEMS
    {
        Group_mode_DO_4,
        Group_output_DO_4,
        Group_setpoint_DO_4,
        Group_rcas_in_DO_4,
        Group_rcas_out_DO_4,
        method_set
    }
}

MENU Group_mode_DO_4
{
    LABEL        "Config Block Mode";
    ITEMS
    {
        func5_DO_4_target_mode,
        COLUMNBREAK,
        func5_DO_4_actual_mode
    }
}

MENU Group_output_DO_4
{
    LABEL        "Set Output (MAN)"; /* [func_out_value]; */
    ITEMS
    {
        func5_DO_4_out_value,
        COLUMNBREAK,
        func5_DO_4_out_status_quality,
        func5_DO_4_out_status_limit
    }
}

MENU Group_setpoint_DO_4
{
    LABEL        "Set Setpoint from Operator - SP (AUTO)"; /* [func_out_value]; */
    ITEMS
    {
        func5_DO_4_setpoint_value,
        COLUMNBREAK,
        func5_DO_4_setpoint_status_quality,
        func5_DO_4_setpoint_status_limit
    }
}

MENU Group_rcas_in_DO_4
{
    LABEL        "Set Setpoint from Remote Station - RCAS_IN (RCAS)"; /* [func_out_value]; */
    ITEMS
    {
        func5_DO_4_rcas_in_value,
        COLUMNBREAK,
        func5_DO_4_rcas_in_status_quality,
        func5_DO_4_rcas_in_status_limit
    }
}

MENU Group_rcas_out_DO_4
{
    LABEL        "From RCAS_OUT to Remote Station"; /* [func_out_value]; */
    ITEMS
    {
        func5_DO_4_rcas_out_value,
        COLUMNBREAK,
        func5_DO_4_rcas_out_status_quality,
        func5_DO_4_rcas_out_status_limit
    }
}

MENU Page_actuator_DO_4
{
    LABEL        "Feedback";
    ITEMS
    {
        Group_readback_DO_4,
        func5_DO_4_check_back,
        func5_DO_4_current_state_alarm_sum
    }
}

MENU Group_readback_DO_4
{
    LABEL        "Readback to Transducer"; /* [func_out_value]; */
    ITEMS
    {
        func5_DO_4_readback_value,
        COLUMNBREAK,
        func5_DO_4_readback_status_quality,
        func5_DO_4_readback_status_limit
    }
}

MENU OnlineDialog_simulation_DO_4
{
    LABEL        "Simulate DO-4"; /* "Simulate AI"; */
    ITEMS
    {
        Page_simulation_DO_4,
        Page_simulation_out_DO_4
    }
}

MENU Page_simulation_DO_4
{
    LABEL        [menu_dialog_simulation_input];
    ITEMS
    {
        func5_DO_4_simulation_enabled,
        Group_simulate_value_DO_4,
        Group_readback_DO_4,
        method_set
    }
}

MENU Group_simulate_value_DO_4
{
    LABEL     "Simulation Value";
    ITEMS
    {
        func5_DO_4_simulate_value,
        COLUMNBREAK,
        func5_DO_4_simulate_status_quality,
        func5_DO_4_simulate_status_limit
    }
}

MENU Page_simulation_out_DO_4
{
    LABEL       [menu_dialog_simulation_output];
    ITEMS
    {
        Group_mode_DO_4,
        Group_output_DO_4,
        method_set
    }
}

/*---------------------------------------------------------------------*/
/*    DO-4 : Offline-Windows                                           */
/*---------------------------------------------------------------------*/

MENU OfflineWindow_DO_4_geral
{
    LABEL "DO-4"; 
    ITEMS
    {
        Page_basic_DO_4,
        Page_advanced_DO_4
    }
}

MENU Page_basic_DO_4
{
    LABEL [MC_Tab_basic];
    ITEMS
    {
        Group_target_mode_DO_4,
        Group_channel_DO_4,
        Group_Set_Invert_DO_4
    }
}

MENU Page_advanced_DO_4
{
    LABEL [MC_Tab_advanced];
    ITEMS
    {
        Group_fault_set_DO_4,
        Group_batch_DO_4
    }
}

MENU Page_batch_DO_4
{
    LABEL [MC_Batch_Info];
    ITEMS
    {
        Group_batch_DO_4
    }
}


MENU Group_target_mode_DO_4
{
    LABEL "Config Block Mode";
    ITEMS
    {
        func5_DO_4_target_mode,
        COLUMNBREAK,
        method_write_target_mode_DO_4
    }
}

MENU Group_channel_DO_4
{
    LABEL        "Select Channel";
    ITEMS
    {
        //func5_DO_4_in_channel,
        func5_DO_4_out_channel,
        COLUMNBREAK,
        method_write_channel_in_out_DO_4
    }
}

MENU Group_channel_out_DO_4
{
    LABEL        "Select Output";
    ITEMS
    {
        func5_DO_4_out_channel,
        COLUMNBREAK,
        method_write_channel_out_DO_4
    }
}

MENU Group_Set_Invert_DO_4
{
    LABEL "Set Invert Input Value";
    ITEMS
    {
        func5_DO_4_invert,
        COLUMNBREAK,
        method_write_invert_DO_4
    }
}

MENU Group_fault_set_DO_4
{
    LABEL     "Set Fail Safe Values";
    ITEMS
    {
        func5_DO_4_fsafe_type,
        func5_DO_4_fsafe_value,
        func5_DO_4_fsafe_time,
        COLUMNBREAK,
        method_write_fail_DO_4
    }
}

MENU Group_batch_DO_4
{
    LABEL        "Define Batch Information";
    ITEMS
    {
        func5_DO_4_batch_id,
        func5_DO_4_batch_unit,
        func5_DO_4_batch_operation,
        func5_DO_4_batch_phase,
        COLUMNBREAK,
        method_write_batch_DO_4
    }
}

/*---------------------------------------------------------------------*/
/*    DO-4 : Methods                                                   */
/*---------------------------------------------------------------------*/

METHOD method_write_target_mode_DO_4
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_4_target_mode);
        ReadCommand(read_func5_DO_4_target_mode);
    }
}

METHOD method_write_channel_in_out_DO_4
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_4_in_channel);
        ReadCommand(read_func5_DO_4_in_channel);
        iassign(func5_DO_4_out_channel, func5_DO_4_in_channel);
        WriteCommand(write_func5_DO_4_out_channel);
        ReadCommand(read_func5_DO_4_out_channel);
    }
}

METHOD method_write_channel_out_DO_4
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_4_out_channel);
        ReadCommand(read_func5_DO_4_out_channel);
    }
}

METHOD method_write_invert_DO_4
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_4_invert);
        ReadCommand(read_func5_DO_4_invert);
    }
}


METHOD method_write_scale_in_DO_4
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_4_pv);
        ReadCommand(read_func5_DO_4_pv);
    }
}

METHOD method_write_scale_out_DO_4
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_4_out_scale);
        ReadCommand(read_func5_DO_4_out_scale);
    }
}

METHOD method_write_fail_DO_4
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_4_fsafe_type);
        WriteCommand(write_func5_DO_4_fsafe_time);
        WriteCommand(write_func5_DO_4_fsafe_value);
        ReadCommand(read_func5_DO_4_fsafe_type);
        ReadCommand(read_func5_DO_4_fsafe_time);
        ReadCommand(read_func5_DO_4_fsafe_value);
    }
}

METHOD method_write_batch_DO_4
{
    LABEL "Write";
    DEFINITION
    {
        WriteCommand(write_func5_DO_4_batch_information);
    }
}

METHOD method_set_status_limit_func5_DO_4
{
    CLASS        INPUT;
    LABEL       "set status limit";
    DEFINITION
    {
        int    quality;
        int block_mode;

        quality = ivar_value(func5_DO_4_setpoint_status_quality);
        if ((quality == 0x20) || (quality == 0x30))
            iassign(func5_DO_4_setpoint_status_limit, 0);

        quality = ivar_value(func5_DO_4_rcas_in_status_quality);
        if ((quality == 0x20) || (quality == 0x30))
            iassign(func5_DO_4_rcas_in_status_limit, 0);

        quality = ivar_value(func5_DO_4_simulate_status_quality);
        if ((quality == 0x20) || (quality == 0x30))
            iassign(func5_DO_4_simulate_status_limit, 0);

        block_mode    = ivar_value(func5_DO_4_target_mode);
        quality        = ivar_value(func5_DO_4_out_status_quality);
        if (((block_mode == BLOCK_MODE_MAN) || (block_mode == BLOCK_MODE_LO)) && ((quality == 0x20) || (quality == 0x30)))
            iassign(func5_DO_4_out_status_limit, 0);
    }
}

/***********************************************************************/
/*    ALL DO Function Block : MENUs                                    */
/***********************************************************************/

MENU Menu_DO_off
{
    LABEL "Discrete Output";
    ITEMS
    {
        OfflineWindow_DO_1_geral,
        OfflineWindow_DO_2_geral,
        OfflineWindow_DO_3_geral,
        OfflineWindow_DO_4_geral
    }
}

MENU Menu_DO_on
{
    LABEL "Discrete Output";
    ITEMS
    {
        OnlineDialog_DO_1_setting,
        OnlineDialog_DO_2_setting,
        OnlineDialog_DO_3_setting,
        OnlineDialog_DO_4_setting
    }
}

MENU Menu_simulate_DO
{
    LABEL "Simulate-DO";
    ITEMS
    {
        OnlineDialog_simulation_DO_1,
        OnlineDialog_simulation_DO_2,
        OnlineDialog_simulation_DO_3,
        OnlineDialog_simulation_DO_4
    }
}
//
///* windows */
//
//MENU Page_display_DO_1
//{
//    LABEL        "DO-1";
//    ITEMS
//    {
//        BarVal_display_out_DO_1,
//        Group_display_out_DO_1,
//        BarVal_display_readback_DO_1,
//        Group_display_readback_DO_1
//        /*        Group_display_setpoint,
//        func5_DO_1_position_discrete_value,
//        func5_DO_1_setpoint_deviation,
//        func5_DO_1_check_back             */
//    }
//}
//
//MENU BarVal_display_readback_DO_1
//{
//    LABEL        "Readback to Transducer";
//    ITEMS
//    {
//        func5_DO_1_readback_value,
//        func5_DO_1_pv_lower_range_value        (READ_ONLY),
//        func5_DO_1_pv_upper_range_value        (READ_ONLY)
//    }
//}
//
//MENU Group_display_readback_DO_1
//{
//    LABEL        "Readback to Transducer";
//    ITEMS
//    {
//        func5_DO_1_readback_value,
//        COLUMNBREAK,
//        func5_DO_1_readback_status_quality,
//        func5_DO_1_readback_status_limit
//    }
//}
//
//MENU Group_display_setpoint_DO_1
//{
//    LABEL        [func_DO_setpoint_value];
//    ITEMS
//    {
//        func5_DO_1_setpoint_value                (READ_ONLY),
//        COLUMNBREAK,
//        func5_DO_1_setpoint_status              (READ_ONLY)
//    }
//}
//
//MENU BarVal_display_out_DO_1
//{
//    LABEL            "Output";
//    ITEMS
//    {
//        func5_DO_1_out_value                    (READ_ONLY),
//        func5_DO_1_out_lower_range_value        (READ_ONLY),
//        func5_DO_1_out_upper_range_value        (READ_ONLY)
//    }
//}
//
//MENU Group_display_out_DO_1
//{
//    LABEL            "Output";
//    ITEMS
//    {
//        func5_DO_1_out_value                    (READ_ONLY),
//        COLUMNBREAK,
//        func5_DO_1_out_status                    (READ_ONLY)
//    }
//}
//
///* Menus */
//
////MENU Tab_s_DO_1
////{
////    LABEL        "DO-1";
////    ITEMS
////    {
////        Tab_s_basic_DO_1,
////        Tab_s_advanced_DO_1
////    }
////}
////
////MENU Tab_s_basic_DO_1
////{
////    LABEL        "Basic";
////    ITEMS
////    {
////        Tab_s_target_mode_DO_1,
////        Tab_s_channel_in_DO_1,
////        Tab_s_channel_out_DO_1,
////        Tab_s_invert_DO_1,
////        Tab_s_scale_pv_DO_1,
////        Tab_s_scale_out_DO_1
////    }
////}
////
////MENU Tab_s_advanced_DO_1
////{
////    LABEL        "Advanced";
////    ITEMS
////    {
////        Tab_s_fault_set_DO_1,
////        Tab_s_batch_DO_1
////    }
////}
////
////MENU Tab_s_target_mode_DO_1
////{
////    LABEL        "Select Block Mode";
////    ITEMS
////    {
////        func5_DO_1_target_mode
////    }
////}
////
////MENU Tab_s_channel_in_DO_1
////{
////    LABEL        "Select Input";
////    ITEMS
////    {
////        func5_DO_1_in_channel
////    }
////}
////
////MENU Tab_s_channel_out_DO_1
////{
////    LABEL        "Select Output";
////    ITEMS
////    {
////        func5_DO_1_out_channel
////    }
////}
////
////
////MENU Tab_s_scale_pv_DO_1
////{
////    LABEL "Set Scale of Input Value";
////    ITEMS
////    {
////        func5_DO_1_pv_upper_range_value,
////        func5_DO_1_pv_lower_range_value,
////        func5_DO_1_pv_unit
////    }
////}
////
////MENU Tab_s_scale_out_DO_1
////{
////    LABEL "Set Scale of Output Value";
////    ITEMS
////    {
////        func5_DO_1_out_upper_range_value,
////        func5_DO_1_out_lower_range_value,
////        func5_DO_1_out_unit(READ_ONLY)
////    }
////}
////
////MENU Tab_s_invert_DO_1
////{
////    LABEL        "Select Positioner/Actuator Action";
////    ITEMS
////    {
////        func5_DO_1_invert
////    }
////}
////
////MENU Tab_s_fault_set_DO_1
////{
////    LABEL        "Set Fail Safe Values";
////    ITEMS
////    {
////        func5_DO_1_fsafe_type,
////        func5_DO_1_fsafe_time,
////        func5_DO_1_fsafe_value
////    }
////}
////
////MENU Tab_s_batch_DO_1
////{
////    LABEL        "Define Batch Information";
////    ITEMS
////    {
////        func5_DO_1_batch_id,
////        func5_DO_1_batch_unit,
////        func5_DO_1_batch_operation,
////        func5_DO_1_batch_phase
////    }
////}
//
///* windows */
//
//MENU Page_display_DO_2
//{
//    LABEL        "DO-2";
//    ITEMS
//    {
//        BarVal_display_out_DO_2,
//        Group_display_out_DO_2,
//        BarVal_display_readback_DO_2,
//        Group_display_readback_DO_2
//        /*        Group_display_setpoint,
//        func5_DO_2_position_discrete_value,
//        func5_DO_2_setpoint_deviation,
//        func5_DO_2_check_back             */
//    }
//}
//
//MENU BarVal_display_readback_DO_2
//{
//    LABEL        "Readback to Transducer";
//    ITEMS
//    {
//        func5_DO_2_readback_value,
//        func5_DO_2_pv_lower_range_value        (READ_ONLY),
//        func5_DO_2_pv_upper_range_value        (READ_ONLY)
//    }
//}
//
//MENU Group_display_readback_DO_2
//{
//    LABEL        "Readback to Transducer";
//    ITEMS
//    {
//        func5_DO_2_readback_value,
//        COLUMNBREAK,
//        func5_DO_2_readback_status_quality,
//        func5_DO_2_readback_status_limit
//    }
//}
//
//MENU Group_display_setpoint_DO_2
//{
//    LABEL        [func_DO_setpoint_value];
//    ITEMS
//    {
//        func5_DO_2_setpoint_value            (READ_ONLY),
//        COLUMNBREAK,
//        func5_DO_2_setpoint_status (READ_ONLY)
//    }
//}
//
//MENU BarVal_display_out_DO_2
//{
//    LABEL            "Output";
//    ITEMS
//    {
//        func5_DO_2_out_value                    (READ_ONLY),
//        func5_DO_2_out_lower_range_value        (READ_ONLY),
//        func5_DO_2_out_upper_range_value        (READ_ONLY)
//    }
//}
//
//MENU Group_display_out_DO_2
//{
//    LABEL            "Output";
//    ITEMS
//    {
//        func5_DO_2_out_value                    (READ_ONLY),
//        COLUMNBREAK,
//        func5_DO_2_out_status        (READ_ONLY)
//    }
//}
//
///* Menus */
//
////MENU Tab_s_DO_2
////{
////    LABEL        "DO-2";
////    ITEMS
////    {
////        Tab_s_basic_DO_2,
////        Tab_s_advanced_DO_2
////    }
////}
////
////MENU Tab_s_basic_DO_2
////{
////    LABEL        "Basic";
////    ITEMS
////    {
////        Tab_s_target_mode_DO_2,
////        Tab_s_channel_in_DO_2,
////        Tab_s_channel_out_DO_2,
////        Tab_s_invert_DO_2,
////        Tab_s_scale_pv_DO_2,
////        Tab_s_scale_out_DO_2
////    }
////}
////
////MENU Tab_s_advanced_DO_2
////{
////    LABEL        "Advanced";
////    ITEMS
////    {
////        Tab_s_fault_set_DO_2,
////        Tab_s_batch_DO_2
////    }
////}
////
////MENU Tab_s_target_mode_DO_2
////{
////    LABEL        "Select Block Mode";
////    ITEMS
////    {
////        func5_DO_2_target_mode
////    }
////}
////
////MENU Tab_s_channel_in_DO_2
////{
////    LABEL        "Select Input";
////    ITEMS
////    {
////        func5_DO_2_in_channel
////    }
////}
////
////MENU Tab_s_channel_out_DO_2
////{
////    LABEL        "Select Output";
////    ITEMS
////    {
////        func5_DO_2_out_channel
////    }
////}
////
////
////MENU     Tab_s_scale_pv_DO_2
////{
////    LABEL "Set Scale of Input Value";
////    ITEMS
////    {
////        func5_DO_2_pv_upper_range_value,
////        func5_DO_2_pv_lower_range_value,
////        func5_DO_2_pv_unit
////    }
////}
////
////MENU     Tab_s_scale_out_DO_2
////{
////    LABEL "Set Scale of Output Value";
////    ITEMS
////    {
////        func5_DO_2_out_upper_range_value,
////        func5_DO_2_out_lower_range_value,
////        func5_DO_2_out_unit(READ_ONLY)
////    }
////}
////
////MENU Tab_s_invert_DO_2
////{
////    LABEL        "Select Positioner/Actuator Action";
////    ITEMS
////    {
////        func5_DO_2_invert
////    }
////}
////
////MENU Tab_s_fault_set_DO_2
////{
////    LABEL        "Set Fail Safe Values";
////    ITEMS
////    {
////        func5_DO_2_fsafe_type,
////        func5_DO_2_fsafe_time,
////        func5_DO_2_fsafe_value
////    }
////}
////
////MENU Tab_s_batch_DO_2
////{
////    LABEL        "Define Batch Information";
////    ITEMS
////    {
////        func5_DO_2_batch_id,
////        func5_DO_2_batch_unit,
////        func5_DO_2_batch_operation,
////        func5_DO_2_batch_phase
////    }
////}
//
///* windows */
//
//MENU Page_display_DO_3
//{
//    LABEL        "DO-3";
//    ITEMS
//    {
//        BarVal_display_out_DO_3,
//        Group_display_out_DO_3,
//        BarVal_display_readback_DO_3,
//        Group_display_readback_DO_3
//        /*        Group_display_setpoint,
//        func5_DO_3_position_discrete_value,
//        func5_DO_3_setpoint_deviation,
//        func5_DO_3_check_back             */
//    }
//}
//
//MENU BarVal_display_readback_DO_3
//{
//    LABEL        "Readback to Transducer";
//    ITEMS
//    {
//        func5_DO_3_readback_value,
//        func5_DO_3_pv_lower_range_value        (READ_ONLY),
//        func5_DO_3_pv_upper_range_value        (READ_ONLY)
//    }
//}
//
//MENU Group_display_readback_DO_3
//{
//    LABEL        "Readback to Transducer";
//    ITEMS
//    {
//        func5_DO_3_readback_value,
//        COLUMNBREAK,
//        func5_DO_3_readback_status_quality,
//        func5_DO_3_readback_status_limit
//    }
//}
//
//MENU Group_display_setpoint_DO_3
//{
//    LABEL        [func_DO_setpoint_value];
//    ITEMS
//    {
//        func5_DO_3_setpoint_value            (READ_ONLY),
//        COLUMNBREAK,
//        func5_DO_3_setpoint_status (READ_ONLY)
//    }
//}
//
//MENU BarVal_display_out_DO_3
//{
//    LABEL            "Output";
//    ITEMS
//    {
//        func5_DO_3_out_value                    (READ_ONLY),
//        func5_DO_3_out_lower_range_value        (READ_ONLY),
//        func5_DO_3_out_upper_range_value        (READ_ONLY)
//    }
//}
//
//MENU Group_display_out_DO_3
//{
//    LABEL            "Output";
//    ITEMS
//    {
//        func5_DO_3_out_value                    (READ_ONLY),
//        COLUMNBREAK,
//        func5_DO_3_out_status        (READ_ONLY)
//    }
//}
//
///* Menus */
//
////MENU Tab_s_DO_3
////{
////    LABEL        "DO-3";
////    ITEMS
////    {
////        Tab_s_basic_DO_3,
////        Tab_s_advanced_DO_3
////    }
////}
////
////MENU Tab_s_basic_DO_3
////{
////    LABEL        "Basic";
////    ITEMS
////    {
////        Tab_s_target_mode_DO_3,
////        Tab_s_channel_in_DO_3,
////        Tab_s_channel_out_DO_3,
////        Tab_s_invert_DO_3,
////        Tab_s_scale_pv_DO_3,
////        Tab_s_scale_out_DO_3
////    }
////}
////
////MENU Tab_s_advanced_DO_3
////{
////    LABEL        "Advanced";
////    ITEMS
////    {
////        Tab_s_fault_set_DO_3,
////        Tab_s_batch_DO_3
////    }
////}
////
////MENU Tab_s_target_mode_DO_3
////{
////    LABEL        "Select Block Mode";
////    ITEMS
////    {
////        func5_DO_3_target_mode
////    }
////}
////
////MENU Tab_s_channel_in_DO_3
////{
////    LABEL        "Select Input";
////    ITEMS
////    {
////        func5_DO_3_in_channel
////    }
////}
////
////MENU Tab_s_channel_out_DO_3
////{
////    LABEL        "Select Output";
////    ITEMS
////    {
////        func5_DO_3_out_channel
////    }
////}
////
////
////MENU     Tab_s_scale_pv_DO_3
////{
////    LABEL "Set Scale of Input Value";
////    ITEMS
////    {
////        func5_DO_3_pv_upper_range_value,
////        func5_DO_3_pv_lower_range_value,
////        func5_DO_3_pv_unit
////    }
////}
////
////MENU     Tab_s_scale_out_DO_3
////{
////    LABEL "Set Scale of Output Value";
////    ITEMS
////    {
////        func5_DO_3_out_upper_range_value,
////        func5_DO_3_out_lower_range_value,
////        func5_DO_3_out_unit(READ_ONLY)
////    }
////}
////
////MENU Tab_s_invert_DO_3
////{
////    LABEL        "Select Positioner/Actuator Action";
////    ITEMS
////    {
////        func5_DO_3_invert
////    }
////}
////
////MENU Tab_s_fault_set_DO_3
////{
////    LABEL        "Set Fail Safe Values";
////    ITEMS
////    {
////        func5_DO_3_fsafe_type,
////        func5_DO_3_fsafe_time,
////        func5_DO_3_fsafe_value
////    }
////}
////
////MENU Tab_s_batch_DO_3
////{
////    LABEL        "Define Batch Information";
////    ITEMS
////    {
////        func5_DO_3_batch_id,
////        func5_DO_3_batch_unit,
////        func5_DO_3_batch_operation,
////        func5_DO_3_batch_phase
////    }
////}
//
///* windows */
//
//MENU Page_display_DO_4
//{
//    LABEL        "DO-4";
//    ITEMS
//    {
//        BarVal_display_out_DO_4,
//        Group_display_out_DO_4,
//        BarVal_display_readback_DO_4,
//        Group_display_readback_DO_4
//        /*        Group_display_setpoint,
//        func5_DO_4_position_discrete_value,
//        func5_DO_4_setpoint_deviation,
//        func5_DO_4_check_back             */
//    }
//}
//
//MENU BarVal_display_readback_DO_4
//{
//    LABEL        "Readback to Transducer";
//    ITEMS
//    {
//        func5_DO_4_readback_value,
//        func5_DO_4_pv_lower_range_value        (READ_ONLY),
//        func5_DO_4_pv_upper_range_value        (READ_ONLY)
//    }
//}
//
//MENU Group_display_readback_DO_4
//{
//    LABEL        "Readback to Transducer";
//    ITEMS
//    {
//        func5_DO_4_readback_value,
//        COLUMNBREAK,
//        func5_DO_4_readback_status_quality,
//        func5_DO_4_readback_status_limit
//    }
//}
//
//MENU Group_display_setpoint_DO_4
//{
//    LABEL        [func_DO_setpoint_value];
//    ITEMS
//    {
//        func5_DO_4_setpoint_value            (READ_ONLY),
//        COLUMNBREAK,
//        func5_DO_4_setpoint_status (READ_ONLY)
//    }
//}
//
//MENU BarVal_display_out_DO_4
//{
//    LABEL            "Output";
//    ITEMS
//    {
//        func5_DO_4_out_value                    (READ_ONLY),
//        func5_DO_4_out_lower_range_value        (READ_ONLY),
//        func5_DO_4_out_upper_range_value        (READ_ONLY)
//    }
//}
//
//MENU Group_display_out_DO_4
//{
//    LABEL            "Output";
//    ITEMS
//    {
//        func5_DO_4_out_value                    (READ_ONLY),
//        COLUMNBREAK,
//        func5_DO_4_out_status        (READ_ONLY)
//    }
//}
//
///* Menus */
//
////MENU Tab_s_DO_4
////{
////    LABEL        "DO-4";
////    ITEMS
////    {
////        Tab_s_basic_DO_4,
////        Tab_s_advanced_DO_4
////    }
////}
////
////MENU Tab_s_basic_DO_4
////{
////    LABEL        "Basic";
////    ITEMS
////    {
////        Tab_s_target_mode_DO_4,
////        Tab_s_channel_in_DO_4,
////        Tab_s_channel_out_DO_4,
////        Tab_s_invert_DO_4,
////        Tab_s_scale_pv_DO_4,
////        Tab_s_scale_out_DO_4
////    }
////}
////
////MENU Tab_s_advanced_DO_4
////{
////    LABEL        "Advanced";
////    ITEMS
////    {
////        Tab_s_fault_set_DO_4,
////        Tab_s_batch_DO_4
////    }
////}
////
////MENU Tab_s_target_mode_DO_4
////{
////    LABEL        "Select Block Mode";
////    ITEMS
////    {
////        func5_DO_4_target_mode
////    }
////}
////
////MENU Tab_s_channel_in_DO_4
////{
////    LABEL        "Select Input";
////    ITEMS
////    {
////        func5_DO_4_in_channel
////    }
////}
////
////MENU Tab_s_channel_out_DO_4
////{
////    LABEL        "Select Output";
////    ITEMS
////    {
////        func5_DO_4_out_channel
////    }
////}
////
////
////MENU     Tab_s_scale_pv_DO_4
////{
////    LABEL "Set Scale of Input Value";
////    ITEMS
////    {
////        func5_DO_4_pv_upper_range_value,
////        func5_DO_4_pv_lower_range_value,
////        func5_DO_4_pv_unit
////    }
////}
////
////MENU     Tab_s_scale_out_DO_4
////{
////    LABEL "Set Scale of Output Value";
////    ITEMS
////    {
////        func5_DO_4_out_upper_range_value,
////        func5_DO_4_out_lower_range_value,
////        func5_DO_4_out_unit(READ_ONLY)
////    }
////}
////
////MENU Tab_s_invert_DO_4
////{
////    LABEL        "Select Positioner/Actuator Action";
////    ITEMS
////    {
////        func5_DO_4_invert
////    }
////}
////
////MENU Tab_s_fault_set_DO_4
////{
////    LABEL        "Set Fail Safe Values";
////    ITEMS
////    {
////        func5_DO_4_fsafe_type,
////        func5_DO_4_fsafe_time,
////        func5_DO_4_fsafe_value
////    }
////}
////
////MENU Tab_s_batch_DO_4
////{
////    LABEL        "Define Batch Information";
////    ITEMS
////    {
////        func5_DO_4_batch_id,
////        func5_DO_4_batch_unit,
////        func5_DO_4_batch_operation,
////        func5_DO_4_batch_phase
////    }
////}
